/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelper {
    public static final String LOGGER_ID = "org.eclipse.orion.server.core";
    private static Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.core");

    private static void doLog(IStatus status) {
        IStatus coreStatus;
        boolean stackCode;
        if (status.isOK()) {
            return;
        }
        Throwable t = status.getException();
        if (status.getSeverity() == 4) {
            logger.error(status.getMessage(), t);
        } else {
            logger.warn(status.getMessage(), t);
        }
        boolean bl = stackCode = t instanceof CoreException;
        if (stackCode && (coreStatus = ((CoreException)t).getStatus()) != null) {
            LogHelper.doLog(coreStatus);
        }
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                LogHelper.doLog(children[i]);
                ++i;
            }
        }
    }

    public static void log(IStatus status) {
        if (logger != null) {
            LogHelper.doLog(status);
        } else {
            System.out.println(status.getMessage());
            if (status.getException() != null) {
                status.getException().printStackTrace();
            }
        }
    }

    public static void log(Throwable t) {
        LogHelper.log((IStatus)new Status(4, LOGGER_ID, "Internal server error", t));
    }
}

