/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.authentication;

import java.util.ArrayList;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.IMetaStore;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String PI_AUTHENTICATION_SERVLETS = "org.eclipse.orion.server.authentication";
    private static volatile BundleContext bundleContext;
    public static Activator singleton;

    public static Activator getDefault() {
        return singleton;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.core");
        IMetaStore metastore = OrionConfiguration.getMetaStore();
        if (metastore == null) {
            String msg = "Fatal error starting authentication service. Server metastore is unavailable!";
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("Email");
        keys.add("OAuth");
        keys.add("OpenId");
        metastore.registerUserProperties(keys);
        logger.debug("Started orion server authentication.");
    }

    public void stop(BundleContext context) throws Exception {
        bundleContext = null;
    }
}

