/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.commands.GetServiceCommand;
import org.eclipse.orion.server.cf.objects.Service;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.cf.utils.MultiServerStatus;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetServiceInstancesCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get service instances";

    public GetServiceInstancesCommand(Target target) {
        super(target);
    }

    @Override
    protected ServerStatus _doIt() {
        MultiServerStatus status = new MultiServerStatus();
        try {
            JSONObject response = new JSONObject();
            JSONArray services = new JSONArray();
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            String spaceGuid = this.target.getSpace().getGuid();
            URI serviceInstancesURI = targetURI.resolve("/v2/spaces/" + spaceGuid + "/service_instances");
            NameValuePair[] pa = new NameValuePair[]{new NameValuePair("return_user_provided_service_instances", "true"), new NameValuePair("inline-relations-depth", "1")};
            do {
                GetMethod getServiceInstancesMethod = new GetMethod(serviceInstancesURI.toString());
                getServiceInstancesMethod.setQueryString(pa);
                HttpUtil.configureHttpMethod((HttpMethod)getServiceInstancesMethod, this.target.getCloud());
                ServerStatus jobStatus = HttpUtil.executeMethod((HttpMethodBase)getServiceInstancesMethod);
                status.add(jobStatus);
                if (!jobStatus.isOK()) {
                    return status;
                }
                JSONObject resp = jobStatus.getJsonData();
                serviceInstancesURI = resp.has("next_url") && !resp.isNull("next_url") ? targetURI.resolve(resp.getString("next_url")) : null;
                JSONArray resources = resp.getJSONArray("resources");
                int i = 0;
                while (i < resources.length()) {
                    JSONObject serviceObj = resources.getJSONObject(i);
                    JSONObject serviceInstanceEntity = serviceObj.getJSONObject("entity");
                    boolean isBindable = true;
                    if (serviceInstanceEntity.has("service_plan")) {
                        JSONObject serviceEntity = serviceInstanceEntity.getJSONObject("service_plan").getJSONObject("entity");
                        String serviceGuid = serviceEntity.getString("service_guid");
                        GetServiceCommand getServiceCommand = new GetServiceCommand(this.target, serviceGuid);
                        jobStatus = (ServerStatus)getServiceCommand.doIt();
                        status.add(jobStatus);
                        if (!jobStatus.isOK()) {
                            return status;
                        }
                        JSONObject serviceResp = jobStatus.getJsonData();
                        isBindable = serviceResp.getJSONObject("entity").getBoolean("bindable");
                    }
                    if (isBindable) {
                        Service s = new Service(serviceInstanceEntity.getString("name"));
                        services.put((Object)s.toJSON());
                    }
                    ++i;
                }
            } while (serviceInstancesURI != null);
            response.put("Children", (Object)services);
            return new ServerStatus(Status.OK_STATUS, 200, response);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            status.add(new ServerStatus(4, 500, msg, (Throwable)e));
            return status;
        }
    }
}

