/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.RevertCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.UnmergedPathException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.task.TaskJobHandler;
import org.eclipse.orion.internal.server.servlets.useradmin.UserEmailUtil;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.core.tasks.TaskJob;
import org.eclipse.orion.server.git.AdditionalRebaseStatus;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.jobs.LogJob;
import org.eclipse.orion.server.git.objects.Commit;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.git.servlets.GitTagHandlerV1;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitCommitHandlerV1
extends AbstractGitHandler {
    private static final String EMAIL_REVIEW_REQUEST_FILE = "/emails/EmailReviewRequestNotification.txt";
    private static final String EMAIL_COMMITER_NAME = "<COMMITER_NAME>";
    private static final String EMAIL_COMMIT_MESSAGE = "<COMMIT_MESSAGE>";
    private static final String EMAIL_URL_LINK = "<URL>";
    private static final int PAGE_SIZE = 50;
    private Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.git");
    private EmailContent reviewRequestEmail;

    GitCommitHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    private boolean identifyNewCommitResource(HttpServletRequest request, HttpServletResponse response, Repository db, String newCommit) throws ServletException {
        try {
            URI u = GitCommitHandlerV1.getURI((HttpServletRequest)request);
            Path p = new Path(u.getPath());
            Path np = new Path("/");
            int i = 0;
            while (i < p.segmentCount()) {
                String s = p.segment(i);
                if (i == 2) {
                    s = String.valueOf(s) + ".." + GitUtils.encode(newCommit);
                }
                np = np.append(s);
                ++i;
            }
            if (p.hasTrailingSeparator()) {
                np = np.addTrailingSeparator();
            }
            URI nu = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), np.toString(), request.getQueryString(), u.getFragment());
            JSONObject result = new JSONObject();
            result.put("Location", (Object)nu);
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            response.setHeader("Location", GitCommitHandlerV1.resovleOrionURI((HttpServletRequest)request, (URI)nu).toString());
            return true;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when identifying a new Commit resource.", (Throwable)e));
        }
    }

    @Override
    protected boolean handleGet(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String gitSegment = requestInfo.gitSegment;
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        String pattern = requestInfo.relativePath;
        IPath filePath = requestInfo.filePath;
        try {
            if (gitSegment == null) {
                return this.handleGetCommitLog(request, response, filePath, db, null, pattern);
            }
            String parts = request.getParameter("parts");
            if ("body".equals(parts)) {
                return this.handleGetCommitBody(request, response, db, gitSegment, pattern);
            }
            if (parts == null || "log".equals(parts)) {
                return this.handleGetCommitLog(request, response, filePath, db, gitSegment, pattern);
            }
            return false;
        }
        catch (Exception e) {
            String msg = "An error occurred while requesting commit information.";
            this.logger.error(String.valueOf(msg) + " " + requestInfo.request.getRequestURI(), (Throwable)e);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
        }
    }

    private boolean handleGetCommitBody(HttpServletRequest request, HttpServletResponse response, Repository db, String ref, String pattern) throws IOException, ServletException, CoreException {
        ObjectId refId = db.resolve(ref);
        if (refId == null) {
            String msg = NLS.bind((String)"Failed to get commit body for ref {0}", (Object)ref);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
        }
        RevWalk walk = new RevWalk(db);
        walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilterGroup.createFromStrings(Collections.singleton(pattern)), (TreeFilter)TreeFilter.ANY_DIFF));
        RevCommit revCommit = walk.parseCommit((AnyObjectId)refId);
        walk.dispose();
        Commit commit = new Commit(null, db, revCommit, pattern);
        ObjectStream stream = commit.toObjectStream();
        if (stream == null) {
            String msg = NLS.bind((String)"Commit body for ref {0} not found", (Object)ref);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
        }
        IOUtilities.pipe((InputStream)stream, (OutputStream)response.getOutputStream(), (boolean)true, (boolean)false);
        return true;
    }

    private boolean handleGetCommitLog(HttpServletRequest request, HttpServletResponse response, IPath filePath, Repository db, String refIdsRange, String pattern) throws AmbiguousObjectException, IOException, ServletException, JSONException, URISyntaxException, CoreException {
        int page = request.getParameter("page") != null ? new Integer(request.getParameter("page")) : 0;
        int pageSize = request.getParameter("pageSize") != null ? new Integer(request.getParameter("pageSize")) : 50;
        String messageFilter = request.getParameter("filter");
        String authorFilter = request.getParameter("author");
        String committerFilter = request.getParameter("committer");
        String sha1Filter = request.getParameter("sha1");
        String fromDate = request.getParameter("fromDate");
        String toDate = request.getParameter("toDate");
        String mergeBaseFilter = request.getParameter("mergeBase");
        ObjectId toObjectId = null;
        ObjectId fromObjectId = null;
        Ref toRefId = null;
        Ref fromRefId = null;
        if (refIdsRange != null) {
            if (refIdsRange.contains("..")) {
                String[] commits = refIdsRange.split("\\.\\.");
                if (commits.length != 2) {
                    String msg = NLS.bind((String)"Failed to generate commit log for ref {0}", (Object)refIdsRange);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                fromObjectId = db.resolve(commits[0]);
                fromRefId = db.getRef(commits[0]);
                if (fromObjectId == null) {
                    String msg = NLS.bind((String)"Failed to generate commit log for ref {0}", (Object)commits[0]);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
                }
                toObjectId = db.resolve(commits[1]);
                toRefId = db.getRef(commits[1]);
                if (toObjectId == null) {
                    String msg = NLS.bind((String)"No ref or commit found: {0}", (Object)commits[1]);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
                }
            } else {
                toObjectId = db.resolve(refIdsRange);
                toRefId = db.getRef(refIdsRange);
                if (toObjectId == null) {
                    String msg = NLS.bind((String)"No ref or commit found: {0}", (Object)refIdsRange);
                    return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, msg, null));
                }
            }
            toObjectId = this.getCommitObjectId(db, toObjectId);
        }
        URI baseLocation = GitCommitHandlerV1.getURI((HttpServletRequest)request);
        URI cloneLocation = BaseToCloneConverter.getCloneLocation(baseLocation, refIdsRange == null ? BaseToCloneConverter.COMMIT : BaseToCloneConverter.COMMIT_REFRANGE);
        LogJob job = new LogJob(TaskJobHandler.getUserId((HttpServletRequest)request), filePath, cloneLocation, page, pageSize, toObjectId, fromObjectId, toRefId, fromRefId, refIdsRange, pattern, messageFilter, authorFilter, committerFilter, sha1Filter, "true".equals(mergeBaseFilter), fromDate, toDate);
        return TaskJobHandler.handleTaskJob((HttpServletRequest)request, (HttpServletResponse)response, (TaskJob)job, (ServletResourceHandler)this.statusHandler, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
    }

    private ObjectId getCommitObjectId(Repository db, ObjectId oid) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevWalk walk = new RevWalk(db);
        try {
            RevCommit revCommit = walk.parseCommit((AnyObjectId)oid);
            return revCommit;
        }
        finally {
            walk.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean handlePost(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String gitSegment = requestInfo.gitSegment;
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        String pattern = requestInfo.relativePath;
        JSONObject requestObject = requestInfo.getJSONRequest();
        try {
            String commitToMerge = requestObject.optString("Merge", null);
            if (commitToMerge != null) {
                boolean squash = requestObject.optBoolean("Squash", false);
                return this.merge(request, response, db, commitToMerge, squash);
            }
            String commitToRebase = requestObject.optString("Rebase", null);
            String rebaseOperation = requestObject.optString("Operation", null);
            if (commitToRebase != null) {
                return this.rebase(request, response, db, commitToRebase, rebaseOperation);
            }
            String commitToCherryPick = requestObject.optString("Cherry-Pick", null);
            if (commitToCherryPick != null) {
                return this.cherryPick(request, response, db, commitToCherryPick);
            }
            String commitToRevert = requestObject.optString("Revert", null);
            if (commitToRevert != null) {
                return this.revert(request, response, db, commitToRevert);
            }
            String newCommit = requestObject.optString("New", null);
            if (newCommit != null) {
                return this.identifyNewCommitResource(request, response, db, newCommit);
            }
            String reviewReqLogin = requestObject.optString("ReviewReqNotifyLogin");
            if (reviewReqLogin != null && reviewReqLogin.length() != 0) {
                String reviewReqUrl = requestObject.optString("ReviewReqUrl");
                String ReviewReqCommit = requestObject.optString("ReviewReqCommit");
                String ReviewReqAuthorName = requestObject.optString("ReviewReqAuthorName");
                String ReviewMessage = requestObject.optString("ReviewMessage");
                return this.sendNotification(request, response, db, reviewReqLogin, ReviewReqCommit, reviewReqUrl, ReviewReqAuthorName, ReviewMessage);
            }
            ObjectId refId = db.resolve(gitSegment);
            if (refId == null || !"HEAD".equals(gitSegment)) {
                String msg = NLS.bind((String)"Commit failed. Ref must be HEAD and is {0}", (Object)gitSegment);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            String message = requestObject.optString("Message", null);
            if (message == null || message.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Missing commit message.", null));
            }
            Git git = new Git(db);
            CommitCommand cc = git.commit();
            StoredConfig config = git.getRepository().getConfig();
            boolean amend = Boolean.parseBoolean(requestObject.optString("Amend", null));
            boolean insertChangeId = config.getBoolean("gerrit", "createchangeid", false) || Boolean.parseBoolean(requestObject.optString("ChangeId", null));
            String committerName = requestObject.optString("CommitterName", null);
            String committerEmail = requestObject.optString("CommitterEmail", null);
            String authorName = requestObject.optString("AuthorName", null);
            String authorEmail = requestObject.optString("AuthorEmail", null);
            PersonIdent defPersonIdent = new PersonIdent(db);
            if (committerName == null) {
                committerName = defPersonIdent.getName();
            }
            if (committerEmail == null) {
                committerEmail = defPersonIdent.getEmailAddress();
            }
            if (authorName == null) {
                authorName = committerName;
            }
            if (authorEmail == null) {
                authorEmail = committerEmail;
            }
            cc.setCommitter(committerName, committerEmail);
            cc.setAuthor(authorName, authorEmail);
            if (insertChangeId) {
                cc.setInsertChangeId(true);
            }
            if (!pattern.isEmpty()) {
                cc.setOnly(pattern);
            }
            try {
                RevCommit lastCommit = cc.setAmend(amend).setMessage(message).call();
                URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitCommitHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.COMMIT_REFRANGE);
                Commit commit = new Commit(cloneLocation, db, lastCommit, pattern);
                JSONObject result = commit.toJSON();
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                return true;
            }
            catch (GitAPIException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "An error occurred when committing.", (Throwable)e));
            }
            catch (UnmergedPathException e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An internal error occurred when committing.", (Throwable)e));
            }
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when requesting commit information.", (Throwable)e));
        }
    }

    private boolean merge(HttpServletRequest request, HttpServletResponse response, Repository db, String commitToMerge, boolean squash) throws ServletException, JSONException {
        try {
            ObjectId objectId = db.resolve(commitToMerge);
            Git git = new Git(db);
            MergeResult mergeResult = git.merge().setSquash(squash).include((AnyObjectId)objectId).call();
            JSONObject result = new JSONObject();
            result.put("Result", (Object)mergeResult.getMergeStatus().name());
            if (mergeResult.getFailingPaths() != null && !mergeResult.getFailingPaths().isEmpty()) {
                result.put("FailingPaths", mergeResult.getFailingPaths());
            }
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (org.eclipse.jgit.api.errors.CheckoutConflictException e) {
            return this.workaroundBug356918(request, response, (Exception)((Object)e));
        }
        catch (IOException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when merging.", (Throwable)e));
        }
        catch (GitAPIException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when merging.", (Throwable)e));
        }
    }

    private boolean workaroundBug356918(HttpServletRequest request, HttpServletResponse response, Exception e) throws ServletException, JSONException {
        if (e instanceof org.eclipse.jgit.api.errors.CheckoutConflictException) {
            JSONObject result = new JSONObject();
            result.put("Result", (Object)MergeResult.MergeStatus.FAILED.name());
            HashMap<String, ResolveMerger.MergeFailureReason> failingPaths = new HashMap<String, ResolveMerger.MergeFailureReason>();
            String[] files = e.getMessage().split("\n");
            int i = 1;
            while (i < files.length) {
                failingPaths.put(files[i], ResolveMerger.MergeFailureReason.DIRTY_WORKTREE);
                ++i;
            }
            result.put("FailingPaths", failingPaths);
            try {
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                return true;
            }
            catch (IOException e1) {
                e = e1;
            }
        }
        return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when merging.", e.getCause()));
    }

    private boolean rebase(HttpServletRequest request, HttpServletResponse response, Repository db, String commitToRebase, String rebaseOperation) throws ServletException, JSONException, AmbiguousObjectException, IOException {
        JSONObject result = new JSONObject();
        try {
            Git git = new Git(db);
            RebaseCommand rebase = git.rebase();
            RebaseCommand.Operation operation = rebaseOperation != null ? RebaseCommand.Operation.valueOf((String)rebaseOperation) : RebaseCommand.Operation.BEGIN;
            if (commitToRebase != null && !commitToRebase.isEmpty()) {
                ObjectId objectId = db.resolve(commitToRebase);
                rebase.setUpstream((AnyObjectId)objectId);
            } else if (operation.equals((Object)RebaseCommand.Operation.BEGIN)) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Missing commit refId.", null));
            }
            rebase.setOperation(operation);
            RebaseResult rebaseResult = rebase.call();
            result.put("Result", (Object)rebaseResult.getStatus().name());
        }
        catch (UnmergedPathsException unmergedPathsException) {
            result.put("Result", (Object)AdditionalRebaseStatus.FAILED_UNMERGED_PATHS.name());
        }
        catch (WrongRepositoryStateException wrongRepositoryStateException) {
            result.put("Result", (Object)AdditionalRebaseStatus.FAILED_WRONG_REPOSITORY_STATE.name());
        }
        catch (IllegalArgumentException e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Invalid rebase operation.", (Throwable)e));
        }
        catch (GitAPIException e) {
            if (e.getCause() instanceof CheckoutConflictException) {
                result.put("Result", (Object)AdditionalRebaseStatus.FAILED_PENDING_CHANGES.name());
            }
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when rebasing.", (Throwable)e));
        }
        OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
        return true;
    }

    private boolean cherryPick(HttpServletRequest request, HttpServletResponse response, Repository db, String commitToCherryPick) throws ServletException, JSONException {
        RevWalk revWalk = new RevWalk(db);
        try {
            Ref headRef = db.getRef("HEAD");
            if (headRef == null) {
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when cherry-picking.", null));
                return bl;
            }
            RevCommit head = revWalk.parseCommit((AnyObjectId)headRef.getObjectId());
            ObjectId objectId = db.resolve(commitToCherryPick);
            Git git = new Git(db);
            CherryPickResult cherryPickResult = git.cherryPick().include((AnyObjectId)objectId).call();
            RevCommit newHead = cherryPickResult.getNewHead();
            JSONObject result = new JSONObject();
            result.put("Result", (Object)cherryPickResult.getStatus().name());
            result.put("HeadUpdated", !head.equals((AnyObjectId)newHead));
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (IOException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when cherry-picking.", (Throwable)e));
            return bl;
        }
        catch (GitAPIException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when cherry-picking.", (Throwable)e));
            return bl;
        }
        finally {
            revWalk.release();
        }
    }

    private boolean revert(HttpServletRequest request, HttpServletResponse response, Repository db, String commitToRevert) throws ServletException, JSONException {
        RevWalk revWalk = new RevWalk(db);
        try {
            Ref headRef = db.getRef("HEAD");
            if (headRef == null) {
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when reverting.", null));
                return bl;
            }
            ObjectId objectId = db.resolve(commitToRevert);
            Git git = new Git(db);
            RevertCommand revertCommand = git.revert().include((AnyObjectId)objectId);
            RevCommit revertedCommit = revertCommand.call();
            if (revertedCommit == null) {
                JSONObject result = new JSONObject();
                result.put("Result", (Object)"FAILURE");
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                return true;
            }
            JSONObject result = new JSONObject();
            result.put("Result", (Object)"OK");
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (IOException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when reverting.", (Throwable)e));
            return bl;
        }
        catch (GitAPIException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when reverting.", (Throwable)e));
            return bl;
        }
        finally {
            revWalk.release();
        }
    }

    private boolean sendNotification(HttpServletRequest request, HttpServletResponse response, Repository db, String login, String commit, String url, String authorName, String message) throws ServletException, URISyntaxException, IOException, JSONException, CoreException, Exception {
        UserEmailUtil util = UserEmailUtil.getUtil();
        if (!util.isEmailConfigured()) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "SMTP server not configured", null));
        }
        UserInfo userInfo = null;
        try {
            userInfo = OrionConfiguration.getMetaStore().readUserByProperty("UserName", login, false, false);
        }
        catch (CoreException e) {
            LogHelper.log((Throwable)e);
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, e.getMessage(), (Throwable)e));
        }
        try {
            if (this.reviewRequestEmail == null) {
                this.reviewRequestEmail = new EmailContent(EMAIL_REVIEW_REQUEST_FILE);
            }
            String emailAdress = userInfo.getProperty("Email");
            util.sendEmail(this.reviewRequestEmail.getTitle(), this.reviewRequestEmail.getContent().replaceAll(EMAIL_COMMITER_NAME, authorName).replaceAll(EMAIL_URL_LINK, url).replaceAll(EMAIL_COMMIT_MESSAGE, message), emailAdress);
            JSONObject result = new JSONObject();
            result.put("Result", (Object)"Email sent");
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (Exception exception) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "User doesn't exist", null));
        }
    }

    @Override
    protected boolean handlePut(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String gitSegment = requestInfo.gitSegment;
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        String filePath = requestInfo.relativePath;
        JSONObject toPut = requestInfo.getJSONRequest();
        try {
            boolean isRoot = "".equals(filePath);
            String tagName = toPut.getString("Name");
            if (tagName != null) {
                return this.tag(request, response, db, gitSegment, tagName, isRoot);
            }
            return false;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when tagging.", (Throwable)e));
        }
    }

    private boolean tag(HttpServletRequest request, HttpServletResponse response, Repository db, String commitId, String tagName, boolean isRoot) throws JSONException, URISyntaxException, ServletException {
        Git git = new Git(db);
        RevWalk walk = new RevWalk(db);
        try {
            ObjectId objectId = db.resolve(commitId);
            RevCommit revCommit = walk.lookupCommit((AnyObjectId)objectId);
            walk.parseBody((RevObject)revCommit);
            GitTagHandlerV1.tag(git, revCommit, tagName);
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitCommitHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.COMMIT_REFRANGE);
            Commit commit = new Commit(cloneLocation, db, revCommit, null);
            JSONObject result = commit.toJSON();
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
            return true;
        }
        catch (IOException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when tagging.", (Throwable)e));
            return bl;
        }
        catch (GitAPIException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when tagging.", (Throwable)e));
            return bl;
        }
        catch (CoreException e) {
            boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occurred when tagging.", (Throwable)e));
            return bl;
        }
        finally {
            walk.dispose();
        }
    }

    public class EmailContent {
        private String title;
        private String content;

        public String getTitle() {
            return this.title;
        }

        public String getContent() {
            return this.content;
        }

        public EmailContent(String fileName) throws URISyntaxException, IOException {
            URL entry = this.getClass().getResource(fileName);
            if (entry == null) {
                throw new IOException("File not found: " + fileName);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(entry.openStream()));
            String line = null;
            try {
                this.title = reader.readLine();
                StringBuilder stringBuilder = new StringBuilder();
                String ls = System.getProperty("line.separator");
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line);
                    stringBuilder.append(ls);
                }
                this.content = stringBuilder.toString();
            }
            finally {
                reader.close();
            }
        }
    }
}

