/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.file.DirectoryHandlerV1;
import org.eclipse.orion.internal.server.servlets.file.NewFileServlet;
import org.eclipse.orion.internal.server.servlets.file.ServletFileStoreHandler;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectParentDecorator
implements IWebResourceDecorator {
    public void addAtributesFor(HttpServletRequest request, URI resource, JSONObject representation) {
        if (!"/file".equals(request.getServletPath())) {
            return;
        }
        try {
            String projectName;
            Path resourcePath;
            Path basePath;
            URI base;
            block8: {
                base = new URI(resource.getScheme(), resource.getUserInfo(), resource.getHost(), resource.getPort(), String.valueOf(request.getServletPath()) + "/", null, null);
                basePath = new Path(base.getPath());
                resourcePath = null;
                try {
                    String locationString = representation.getString("Location");
                    URI location = new URI(locationString);
                    resourcePath = new Path(location.getPath());
                }
                catch (JSONException jSONException) {
                    resourcePath = new Path(resource.getPath());
                    if (!resourcePath.hasTrailingSeparator() || representation.getBoolean("Directory")) break block8;
                    resourcePath = resourcePath.append(representation.getString("Name"));
                }
            }
            IPath path = resourcePath.makeRelativeTo((IPath)basePath);
            if (path.segmentCount() < 2) {
                return;
            }
            ProjectInfo project = OrionConfiguration.getMetaStore().readProject(path.segment(0), path.segment(1));
            if (project == null) {
                return;
            }
            String full = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"full");
            this.addParents(base, representation, project, path, request, full);
            if (path.segmentCount() == 2 && (projectName = project.getFullName()) != null) {
                representation.put("Name", (Object)projectName);
            }
        }
        catch (Exception e) {
            LogHelper.log((Throwable)e);
        }
    }

    private void addParents(URI resource, JSONObject representation, ProjectInfo project, IPath resourcePath, HttpServletRequest request, String full) throws JSONException {
        URI uri;
        resourcePath = resourcePath.removeLastSegments(1).addTrailingSeparator();
        JSONArray parents = new JSONArray();
        while (resourcePath.segmentCount() > 2) {
            try {
                uri = resource.resolve(new URI(null, null, resourcePath.toString(), null));
                this.addParent(parents, resourcePath.lastSegment(), new URI(resource.getScheme(), resource.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment()), resourcePath, request, full);
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
            resourcePath = resourcePath.removeLastSegments(1);
        }
        if (resourcePath.segmentCount() == 2) {
            try {
                uri = resource.resolve(new URI(null, null, resourcePath.toString(), null));
                this.addParent(parents, project.getFullName(), new URI(resource.getScheme(), resource.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment()), resourcePath, request, full);
            }
            catch (URISyntaxException e) {
                LogHelper.log((Throwable)e);
            }
        }
        representation.put("Parents", (Object)parents);
    }

    /*
     * Unable to fully structure code
     */
    private void addParent(JSONArray parents, String name, URI location, IPath resourcePath, HttpServletRequest request, String full) throws JSONException {
        if (full != null) {
            try {
                compressed = "compressed".equals(full);
                dir = full != null ? NewFileServlet.getFileStore(request, resourcePath) : null;
                parent = ServletFileStoreHandler.toJSON(dir, dir.fetchInfo(0, null), compressed != false ? null : location);
                DirectoryHandlerV1.encodeChildren(dir, location, parent, 1, compressed == false);
                if (!"decorate".equals(full)) ** GOTO lbl24
                OrionServlet.decorateResponse(request, parent, this);
            }
            catch (CoreException v0) {
                return;
            }
        } else {
            parent = new JSONObject();
            parent.put("Name", (Object)name);
            parent.put("Location", (Object)location);
            try {
                childLocation = new URI(location.getScheme(), location.getUserInfo(), location.getHost(), location.getPort(), location.getPath(), "depth=1", location.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            parent.put("ChildrenLocation", (Object)childLocation);
        }
lbl24:
        // 3 sources

        parents.put((Object)parent);
    }
}

