/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.search;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.internal.server.search.SearchException;
import org.eclipse.orion.internal.server.search.SearchOptions;
import org.eclipse.orion.internal.server.search.SearchResult;
import org.eclipse.orion.internal.server.search.SearchScope;
import org.eclipse.orion.server.core.metastore.ProjectInfo;
import org.eclipse.orion.server.core.metastore.WorkspaceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileGrepper
extends DirectoryWalker<SearchResult> {
    private ProjectInfo currentProject;
    private WorkspaceInfo currentWorkspace;
    private Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.config");
    private Matcher matcher;
    private SearchOptions options;
    private Pattern pattern;

    public FileGrepper(SearchOptions options) throws SearchException {
        this.options = options;
        if (options.isFileContentsSearch()) {
            this.pattern = this.buildSearchPattern();
            this.matcher = this.pattern.matcher("");
        } else {
            options.setFilenamePattern(this.undoLuceneEscape(options.getFilenamePattern()));
        }
    }

    private boolean acceptFilename(String filename) {
        if (this.options.getFilenamePattern() == null) {
            return true;
        }
        String filenamePattern = this.options.getFilenamePattern();
        boolean match = false;
        match = this.options.isFilenamePatternCaseSensitive() ? FilenameUtils.wildcardMatch((String)filename, (String)filenamePattern) : FilenameUtils.wildcardMatch((String)filename.toLowerCase(), (String)filenamePattern.toLowerCase());
        return match;
    }

    private Pattern buildSearchPattern() throws SearchException {
        int flags = 0;
        String searchTerm = this.options.getSearchTerm();
        if (!this.options.isRegEx()) {
            if (searchTerm.startsWith("\"")) {
                searchTerm = searchTerm.substring(1, searchTerm.length() - 1);
            }
            if ((searchTerm = this.undoLuceneEscape(searchTerm)).contains("?") || searchTerm.contains("*")) {
                if (searchTerm.startsWith("*")) {
                    searchTerm = searchTerm.substring(1);
                }
                if (searchTerm.contains("?")) {
                    searchTerm = searchTerm.replace('?', '.');
                }
                if (searchTerm.contains("*")) {
                    searchTerm = searchTerm.replace("*", ".*");
                }
            } else {
                searchTerm = Pattern.quote(searchTerm);
            }
        }
        if (!this.options.isSearchTermCaseSensitive()) {
            flags |= 2;
        }
        try {
            return Pattern.compile(searchTerm, flags);
        }
        catch (PatternSyntaxException e) {
            throw new SearchException(e);
        }
    }

    protected boolean handleDirectory(File directory, int depth, Collection<SearchResult> results) {
        if (results.size() >= this.options.getRows()) {
            return false;
        }
        return !directory.getName().startsWith(".");
    }

    protected void handleFile(File file, int depth, Collection<SearchResult> results) {
        if (results.size() >= this.options.getRows()) {
            return;
        }
        if (!this.acceptFilename(file.getName())) {
            return;
        }
        if (!this.options.isFileContentsSearch() || this.searchFile(file)) {
            IFileStore fileStore;
            try {
                fileStore = EFS.getStore((URI)file.toURI());
            }
            catch (CoreException e) {
                this.logger.error("FileGrepper.handleFile: " + e.getLocalizedMessage(), (Throwable)e);
                return;
            }
            results.add(new SearchResult(fileStore, this.currentWorkspace, this.currentProject));
        }
    }

    public List<SearchResult> search(SearchOptions options) throws SearchException {
        LinkedList<SearchResult> files = new LinkedList<SearchResult>();
        try {
            for (SearchScope scope : options.getScopes()) {
                this.currentWorkspace = scope.getWorkspace();
                this.currentProject = scope.getProject();
                File file = scope.getFile();
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                super.walk(file, files);
            }
        }
        catch (IOException e) {
            throw new SearchException(e);
        }
        return files;
    }

    /*
     * Unable to fully structure code
     */
    private boolean searchFile(File file) {
        lineIterator = null;
        try {
            lineIterator = FileUtils.lineIterator((File)file);
            if (true) ** GOTO lbl15
        }
        catch (IOException e) {
            this.logger.error("FileGrepper.searchFile: " + e.getLocalizedMessage());
            return false;
        }
        {
            do {
                if ((line = lineIterator.nextLine()).contains("\u0000")) {
                    return false;
                }
                this.matcher.reset(line);
                if (!this.matcher.find()) continue;
                return true;
lbl15:
                // 2 sources

            } while (lineIterator.hasNext());
        }
        return false;
    }

    private String undoLuceneEscape(String searchTerm) {
        String specialChars = "+-&|!(){}[]^\"~:\\";
        int i = 0;
        while (i < specialChars.length()) {
            String character = specialChars.substring(i, i + 1);
            String escaped = "\\" + character;
            searchTerm = searchTerm.replaceAll(Pattern.quote(escaped), character);
            ++i;
        }
        return searchTerm;
    }
}

