/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetIsRouteAvailableCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Is Route Available Command";
    private String host;
    private String guid;

    public GetIsRouteAvailableCommand(Target target, String host, String guid) {
        super(target);
        this.host = host;
        this.guid = guid;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.getCloud().getUrl());
            String path = "/v2/routes/reserved/domain/" + this.guid + "/host/" + this.host;
            URI requestURI = targetURI.resolve(path);
            GetMethod getIsRouteAvailableMethod = new GetMethod(requestURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getIsRouteAvailableMethod, this.target.getCloud());
            return HttpUtil.executeMethod((HttpMethodBase)getIsRouteAvailableMethod);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

