/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.AnalyzerException;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.osgi.util.NLS;

public class ApplicationSanizator
implements Analyzer {
    @Override
    public void apply(ManifestParseTree node) throws AnalyzerException {
        if (!node.has("applications")) {
            return;
        }
        try {
            ManifestParseTree applications = node.get("applications");
            for (ManifestParseTree application : applications.getChildren()) {
                String applicationName = application.get("name").getValue();
                this.checkEmptyProperties(applicationName, application);
                ManifestParseTree buildpack = application.getOpt("buildpack");
                this.checkBuildpack(applicationName, buildpack);
                ManifestParseTree command = application.getOpt("command");
                this.checkCommand(applicationName, command);
                ManifestParseTree domain = application.getOpt("domain");
                this.checkDomain(applicationName, domain);
                ManifestParseTree host = application.getOpt("host");
                this.checkHost(applicationName, host);
                ManifestParseTree path = application.getOpt("path");
                this.checkPath(applicationName, path);
                ManifestParseTree memory = application.getOpt("memory");
                this.checkMemory(applicationName, memory);
                ManifestParseTree instances = application.getOpt("instances");
                this.checkInstances(applicationName, instances);
                ManifestParseTree timeout = application.getOpt("timeout");
                this.checkTimeout(applicationName, timeout);
                ManifestParseTree noRoute = application.getOpt("no-route");
                this.checkNoRoute(applicationName, noRoute);
                ManifestParseTree services = application.getOpt("services");
                this.checkServices(applicationName, services);
            }
        }
        catch (InvalidAccessException ex) {
            throw new AnalyzerException(ex.getMessage());
        }
    }

    protected void checkEmptyProperties(String applicationName, ManifestParseTree application) throws AnalyzerException {
        for (ManifestParseTree property : application.getChildren()) {
            if (!property.getChildren().isEmpty()) continue;
            throw new AnalyzerException(NLS.bind((String)"Empty property \"{0}\" in application \"{1}\".", (Object)property.getLabel(), (Object)applicationName), property.getLineNumber());
        }
    }

    protected void checkServices(String applicationName, ManifestParseTree services) throws AnalyzerException {
        if (services == null) {
            return;
        }
        if (services.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid services declaration for application \"{0}\". Expected a list of service names.", (Object)applicationName), services.getLineNumber());
        }
    }

    protected void checkBuildpack(String applicationName, ManifestParseTree buildpack) throws AnalyzerException {
        if (buildpack == null) {
            return;
        }
        if (!buildpack.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"buildpack\" value for application \"{0}\". Expected a string literal.", (Object)applicationName), buildpack.getLineNumber());
        }
    }

    protected void checkCommand(String applicationName, ManifestParseTree command) throws AnalyzerException {
        if (command == null) {
            return;
        }
        if (!command.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"command\" value for application \"{0}\". Expected a string literal.", (Object)applicationName), command.getLineNumber());
        }
    }

    protected void checkDomain(String applicationName, ManifestParseTree domain) throws AnalyzerException {
        if (domain == null) {
            return;
        }
        if (!domain.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"domain\" value for application \"{0}\". Expected a string literal.", (Object)applicationName), domain.getLineNumber());
        }
    }

    protected void checkHost(String applicationName, ManifestParseTree host) throws AnalyzerException {
        if (host == null) {
            return;
        }
        if (!host.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"host\" value for application \"{0}\". Expected a string literal.", (Object)applicationName), host.getLineNumber());
        }
    }

    protected void checkPath(String applicationName, ManifestParseTree path) throws AnalyzerException {
        if (path == null) {
            return;
        }
        if (!path.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"path\" value for application \"{0}\". Expected a path string.", (Object)applicationName), path.getLineNumber());
        }
    }

    protected void checkMemory(String applicationName, ManifestParseTree memory) throws AnalyzerException, InvalidAccessException {
        if (memory == null) {
            return;
        }
        if (!memory.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"memory\" value for application \"{0}\". Expected a memory limit.", (Object)applicationName), memory.getLineNumber());
        }
        if (!memory.isValidMemoryProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid memory limit for application \"{0}\". Supported measurement units are M/MB, G/GB.", (Object)applicationName), memory.getLineNumber());
        }
    }

    protected void checkInstances(String applicationName, ManifestParseTree instances) throws AnalyzerException, InvalidAccessException {
        if (instances == null) {
            return;
        }
        if (!instances.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"instances\" value for application \"{0}\". Expected a non-negative integer value.", (Object)applicationName), instances.getLineNumber());
        }
        if (!instances.isValidNonNegativeProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"instances\" value for application \"{0}\". Expected a non-negative integer value.", (Object)applicationName), instances.getLineNumber());
        }
    }

    protected void checkTimeout(String applicationName, ManifestParseTree timeout) throws AnalyzerException, InvalidAccessException {
        if (timeout == null) {
            return;
        }
        if (!timeout.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"timeout\" value for application \"{0}\". Expected a non-negative integer value.", (Object)applicationName), timeout.getLineNumber());
        }
        if (!timeout.isValidNonNegativeProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"timeout\" value for application \"{0}\". Expected a non-negative integer value.", (Object)applicationName), timeout.getLineNumber());
        }
    }

    protected void checkNoRoute(String applicationName, ManifestParseTree noRoute) throws AnalyzerException, InvalidAccessException {
        if (noRoute == null) {
            return;
        }
        if (!noRoute.isStringProperty()) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"no-route\" value for application \"{0}\". Expected a string literal \"true\".", (Object)applicationName), noRoute.getLineNumber());
        }
        String noRouteValue = noRoute.getValue();
        if (!"true".equals(noRouteValue)) {
            throw new AnalyzerException(NLS.bind((String)"Invalid \"no-route\" value for application \"{0}\". Expected a string literal \"true\".", (Object)applicationName), noRoute.getLineNumber());
        }
    }
}

