/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.tasks;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.core.tasks.TaskDescription;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.CorruptedTaskException;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskInfo {
    public static final String KEY_TYPE = "type";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_LENGTH_COMPUTABLE = "lengthComputable";
    public static final String KEY_LOADED = "loaded";
    public static final String KEY_TOTAL = "total";
    public static final String KEY_EXPIRES = "expires";
    public static final String KEY_RESULT = "Result";
    public static final String KEY_CANCELABLE = "cancelable";
    public static final String KEY_URI_UNQUALIFICATION = "uriUnqualStrategy";
    private static final String STATUS_LOADSTART = "loadstart";
    private static final String STATUS_PROGRESS = "progress";
    private static final String STATUS_ERROR = "error";
    private static final String STATUS_ABORT = "abort";
    private static final String STATUS_LOAD = "load";
    private static final String STATUS_LOADEND = "loadend";
    private final String id;
    private final String userId;
    private boolean keep = true;
    private boolean lengthComputable = false;
    private Date timestamp;
    private Date expires;
    private TaskStatus status = TaskStatus.LOADSTART;
    private int loaded = 0;
    private int total = 0;
    private IStatus result;
    private boolean cancelable = false;
    private IURIUnqualificationStrategy strategy;
    static HashMap<String, IURIUnqualificationStrategy> registry = new HashMap();

    static void addStrategy(IURIUnqualificationStrategy strategy) {
        String name = strategy.getName();
        if (!registry.containsKey(name)) {
            registry.put(name, strategy);
        }
    }

    static IURIUnqualificationStrategy getStrategy(String name) {
        return registry.get(name);
    }

    public static TaskInfo fromJSON(TaskDescription description, String taskString) throws CorruptedTaskException {
        try {
            JSONObject json = new JSONObject(taskString);
            TaskInfo info = new TaskInfo(description.getUserId(), description.getTaskId(), description.isKeep());
            if (json.has(KEY_EXPIRES)) {
                info.expires = new Date(json.getLong(KEY_EXPIRES));
            }
            if (json.has(KEY_TIMESTAMP)) {
                info.timestamp = new Date(json.getLong(KEY_TIMESTAMP));
            }
            info.lengthComputable = json.optBoolean(KEY_LENGTH_COMPUTABLE);
            if (json.has(KEY_LOADED)) {
                info.loaded = json.optInt(KEY_LOADED);
            }
            if (json.has(KEY_TOTAL)) {
                info.total = json.getInt(KEY_TOTAL);
            }
            if (json.has(KEY_TYPE)) {
                info.status = TaskStatus.fromString(json.optString(KEY_TYPE));
            }
            if (json.has(KEY_RESULT)) {
                info.result = ServerStatus.fromJSON(json.optString(KEY_RESULT));
            }
            if (json.has(KEY_URI_UNQUALIFICATION)) {
                info.strategy = TaskInfo.getStrategy(json.optString(KEY_URI_UNQUALIFICATION));
            }
            return info;
        }
        catch (JSONException e) {
            throw new CorruptedTaskException(taskString, e);
        }
    }

    public TaskInfo(String userId, String id, boolean keep) {
        this.keep = keep;
        this.userId = userId;
        this.id = id;
        this.timestamp = new Date();
    }

    public boolean isRunning() {
        return this.status != TaskStatus.LOAD && this.status != TaskStatus.ERROR && this.status != TaskStatus.ABORT && this.status != TaskStatus.LOADEND;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean isLengthComputable() {
        return this.lengthComputable;
    }

    public void setLengthComputable(boolean lengthComputable) {
        this.lengthComputable = lengthComputable;
    }

    public Long getTimestamp() {
        return this.timestamp == null ? null : Long.valueOf(this.timestamp.getTime());
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = new Date(timestamp);
    }

    public Long getExpires() {
        return this.expires == null ? null : Long.valueOf(this.expires.getTime());
    }

    public void setExpires(long expires) {
        this.expires = new Date(expires);
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public IURIUnqualificationStrategy getUnqualificationStrategy() {
        return this.strategy;
    }

    public void setUnqualificationStrategy(IURIUnqualificationStrategy strategy) {
        TaskInfo.addStrategy(strategy);
        this.strategy = strategy;
    }

    public int getLoaded() {
        return this.loaded;
    }

    public void setLoaded(int loaded) {
        this.loaded = loaded;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public IStatus getResult() {
        return this.result;
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    public void done(IStatus result) {
        this.result = result;
        switch (result.getSeverity()) {
            case 0: 
            case 1: {
                this.status = TaskStatus.LOADEND;
                break;
            }
            case 2: 
            case 4: {
                this.status = TaskStatus.ERROR;
                break;
            }
            default: {
                this.status = TaskStatus.ABORT;
            }
        }
        if (this.expires != null) {
            return;
        }
        if (!this.keep) {
            Calendar cal = Calendar.getInstance();
            cal.add(12, 15);
            this.expires = cal.getTime();
        } else {
            Calendar cal = Calendar.getInstance();
            cal.add(5, 7);
            this.expires = cal.getTime();
        }
    }

    public JSONObject toLightJSON() {
        JSONObject resultObject = new JSONObject();
        try {
            IURIUnqualificationStrategy strategy;
            resultObject.put(KEY_LENGTH_COMPUTABLE, this.isLengthComputable());
            if (this.isLengthComputable()) {
                resultObject.put(KEY_LOADED, this.getLoaded());
                resultObject.put(KEY_TOTAL, this.getTotal());
            }
            if (this.getTimestamp() != null) {
                resultObject.put(KEY_TIMESTAMP, (Object)this.getTimestamp());
            }
            if (this.getExpires() != null) {
                resultObject.put(KEY_EXPIRES, (Object)this.getExpires());
            }
            if ((strategy = this.getUnqualificationStrategy()) != null) {
                resultObject.put(KEY_URI_UNQUALIFICATION, (Object)strategy.getName());
            }
            resultObject.put(KEY_TYPE, (Object)this.getStatus().toString());
        }
        catch (JSONException jSONException) {}
        return resultObject;
    }

    public JSONObject toJSON() {
        JSONObject resultObject = new JSONObject();
        try {
            IURIUnqualificationStrategy strategy;
            resultObject.put(KEY_LENGTH_COMPUTABLE, this.isLengthComputable());
            if (this.isLengthComputable()) {
                resultObject.put(KEY_LOADED, this.getLoaded());
                resultObject.put(KEY_TOTAL, this.getTotal());
            }
            if (this.result != null) {
                resultObject.put(KEY_RESULT, (Object)ServerStatus.convert(this.result).toJSON());
            }
            if (this.getTimestamp() != null) {
                resultObject.put(KEY_TIMESTAMP, (Object)this.getTimestamp());
            }
            if (this.getExpires() != null) {
                resultObject.put(KEY_EXPIRES, (Object)this.getExpires());
            }
            if (this.isCancelable()) {
                resultObject.put(KEY_CANCELABLE, this.isCancelable());
            }
            if ((strategy = this.getUnqualificationStrategy()) != null) {
                resultObject.put(KEY_URI_UNQUALIFICATION, (Object)strategy.getName());
            }
            resultObject.put(KEY_TYPE, (Object)this.getStatus().toString());
        }
        catch (JSONException jSONException) {}
        return resultObject;
    }

    public String toString() {
        return "TaskInfo: " + this.toJSON();
    }

    public static enum TaskStatus {
        LOADSTART("loadstart"),
        PROGRESS("progress"),
        ERROR("error"),
        ABORT("abort"),
        LOAD("load"),
        LOADEND("loadend");

        private final String statusString;

        private TaskStatus(String statusString) {
            this.statusString = statusString;
        }

        public String toString() {
            return this.statusString;
        }

        public static TaskStatus fromString(String taskString) {
            if (TaskInfo.STATUS_LOADSTART.equals(taskString)) {
                return LOADSTART;
            }
            if (TaskInfo.STATUS_PROGRESS.equals(taskString)) {
                return PROGRESS;
            }
            if (TaskInfo.STATUS_ERROR.equals(taskString)) {
                return ERROR;
            }
            if (TaskInfo.STATUS_LOAD.equals(taskString)) {
                return LOAD;
            }
            if (TaskInfo.STATUS_LOADEND.equals(taskString)) {
                return LOADEND;
            }
            return ABORT;
        }
    }
}

