/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.gerritfs;

import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.eclipse.orion.server.gerritfs.DiffCommand;
import org.eclipse.orion.server.gerritfs.IOUtilities;
import org.eclipse.orion.server.gerritfs.IPath;
import org.eclipse.orion.server.gerritfs.IURIUnqualificationStrategy;
import org.eclipse.orion.server.gerritfs.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.gerritfs.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Export(value="/diff/*")
@Singleton
public class GitDiff
extends HttpServlet {
    static final String KEY_LOCATION = "Location";
    static final String KEY_PATH = "Path";
    static final String KEY_TYPE = "Type";
    static final String KEY_CHILDREN = "Children";
    static final String KEY_LENGTH = "Length";
    static final String KEY_CONTENT_LOCATION = "ContentLocation";
    static final String KEY_NEXT_LOCATION = "NextLocation";
    static final String CONTENT_TYPE_JSON = "application/json; charset=UTF-8";
    static final String TYPE = "Diff";
    private static final long serialVersionUID = 8817903877306987723L;
    private final GitRepositoryManager repoManager;
    private final ProjectControl.Factory projControlFactory;
    private final Provider<WebSession> session;
    private final AccountCache accountCache;
    private final Config config;
    private final AccountManager accountManager;
    private Repository repo;
    private static Logger log = LoggerFactory.getLogger(GitDiff.class);

    @Inject
    public GitDiff(GitRepositoryManager repoManager, ProjectControl.Factory project, Provider<WebSession> session, AccountCache accountCache, @GerritServerConfig Config config, AccountManager accountManager) {
        this.repoManager = repoManager;
        this.projControlFactory = project;
        this.session = session;
        this.accountCache = accountCache;
        this.config = config;
        this.accountManager = accountManager;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleAuth(req);
        this.identifyNewDiffResource(req, resp);
    }

    private boolean identifyNewDiffResource(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            StringWriter writer = new StringWriter();
            IOUtilities.pipe(request.getReader(), writer, false, false);
            JSONObject requestObject = new JSONObject(writer.toString());
            String path = request.getServletPath();
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                path = path + request.getPathInfo();
            }
            String[] p = path.split("/");
            StringBuffer np = new StringBuffer();
            for (int i = 0; i < p.length; ++i) {
                String s = p[i];
                if (i == 2) {
                    s = s + "..";
                    s = s + GitDiff.encode((String)requestObject.get("New"));
                }
                np = np.append(s);
                np.append("/");
            }
            if (p[p.length - 1].equals("/")) {
                np = np.append("/");
            }
            URI nu = new URI(request.getScheme(), null, np.toString(), null, null);
            JSONObject result = new JSONObject();
            result.put(KEY_LOCATION, nu.toString());
            this.writeJSONResponse(request, response, result);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    void writeJSONResponse(HttpServletRequest req, HttpServletResponse resp, JSONObject result) throws IOException {
        resp.setCharacterEncoding("UTF-8");
        resp.setStatus(200);
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Cache-Control", "no-store");
        IURIUnqualificationStrategy strategy = JsonURIUnqualificationStrategy.ALL_NO_GIT;
        strategy.run(req, result);
        resp.setContentType(CONTENT_TYPE_JSON);
        try {
            String response = result.toString(2);
            resp.getWriter().print(response);
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    protected static URI unqualifyURI(URI uri, String scheme, String hostname, int port) {
        URI simpleURI = uri;
        int uriPort = uri.getPort();
        if (uriPort == -1) {
            uriPort = GitDiff.getDefaultPort(uri.getScheme());
        }
        if (scheme.equals(uri.getScheme()) && hostname.equals(uri.getHost()) && port == uriPort) {
            try {
                simpleURI = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                simpleURI = uri;
            }
        }
        return simpleURI;
    }

    private static int getDefaultPort(String scheme) {
        if ("http".equalsIgnoreCase(scheme)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(scheme)) {
            return 443;
        }
        return -1;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleAuth(request);
        try {
            String parts = request.getParameter("parts");
            String pathInfo = request.getPathInfo();
            Pattern ptrn = Pattern.compile("/([^/]*)(?:/([^/]*)(?:/(.*))?)?");
            Matcher matcher = ptrn.matcher(pathInfo);
            matcher.matches();
            String sha = null;
            String projectName = null;
            String refName = null;
            if (matcher.groupCount() > 0) {
                sha = matcher.group(1);
                projectName = matcher.group(2);
                refName = matcher.group(3);
                sha = sha == null || sha.equals("") ? null : URLDecoder.decode(sha, "UTF-8");
                projectName = projectName == null || projectName.equals("") ? null : URLDecoder.decode(projectName, "UTF-8");
                refName = refName == null || refName.equals("") ? null : URLDecoder.decode(refName, "UTF-8");
            }
            Project.NameKey projName = Project.NameKey.parse(projectName);
            this.repo = this.repoManager.openRepository(projName);
            if ("uris".equals(parts)) {
                this.writeJSONResponse(request, response, this.getDiff(request));
                return;
            }
            if ("diff".equals(parts)) {
                this.handleGetDiff(request, response, this.repo, sha, refName, (OutputStream)response.getOutputStream());
            } else {
                this.handleGetDiffs(request, response, this.repo, sha, refName, (OutputStream)NullOutputStream.INSTANCE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JSONObject getDiff(HttpServletRequest request) {
        URI uri = GitDiff.getURI(request);
        String pathInfo = uri.getPath();
        pathInfo = pathInfo.substring(pathInfo.indexOf("/diff"));
        Pattern ptrn = Pattern.compile("/([^/]*)(?:/([^/]*)(?:/(.*))?)?");
        Matcher matcher = ptrn.matcher(pathInfo);
        matcher.matches();
        Object sha = null;
        String scope = null;
        String refName = null;
        if (matcher.groupCount() > 0) {
            scope = matcher.group(2);
            refName = matcher.group(3);
        }
        JSONObject json = new JSONObject();
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            IPath oldLocation = new Path(request.getContextPath() + "/gitcontents/").append(commits[0]).append("/" + refName);
            IPath newLocation = new Path(request.getContextPath() + "/gitcontents/").append(commits[1]).append("/" + refName);
            try {
                json.put("New", newLocation.toString());
                json.put("Old", oldLocation.toString());
                json.put(KEY_TYPE, TYPE);
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        return json;
    }

    private void handleGetDiff(HttpServletRequest request, HttpServletResponse response, Repository db, String scope, String pattern, OutputStream out) throws Exception {
        DiffCommand command = this.getDiff(request, response, db, scope, pattern, new BufferedOutputStream(out));
        if (command != null) {
            command.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGetDiffs(HttpServletRequest request, HttpServletResponse response, Repository repo, String sha, String refName, OutputStream out) {
        try {
            DiffCommand command = this.getDiff(request, response, repo, sha, refName, out);
            if (command == null) {
                return;
            }
            Object l = command.call();
            JSONArray diffs = new JSONArray();
            URI diffLocation = GitDiff.getURI(request);
            if (refName != null) {
                Path patternPath = new Path(refName);
                IPath diffPath = new Path(diffLocation.getPath());
                diffPath = diffPath.removeLastSegments(patternPath.segmentCount());
                diffLocation = new URI(diffLocation.getScheme(), diffLocation.getAuthority(), diffPath.toPortableString(), null, null);
            }
            URI cloneLocation = this.getCloneLocation(diffLocation);
            int page = request.getParameter("page") != null ? new Integer(request.getParameter("page")) : 0;
            int pageSize = request.getParameter("pageSize") != null ? new Integer(request.getParameter("pageSize")) : Integer.MAX_VALUE;
            int start = pageSize * (page - 1);
            int end = Math.min(pageSize + start, l.size());
            int i = start;
            for (i = start; i < end; ++i) {
                DiffEntry entr = (DiffEntry)l.get(i);
                JSONObject diff = new JSONObject();
                diff.put(KEY_TYPE, TYPE);
                diff.put("NewPath", entr.getNewPath());
                diff.put("OldPath", entr.getOldPath());
                diff.put("ChangeType", entr.getChangeType().toString());
                String path = entr.getChangeType() != DiffEntry.ChangeType.DELETE ? entr.getNewPath() : entr.getOldPath();
                diff.put("DiffLocation", this.createDiffLocation(diffLocation, request, path));
                diff.put(KEY_CONTENT_LOCATION, this.createContentLocation(cloneLocation, entr, path));
                diffs.put(diff);
            }
            JSONObject result = new JSONObject();
            result.put(KEY_TYPE, TYPE);
            result.put(KEY_CHILDREN, diffs);
            result.put(KEY_LENGTH, l.size());
            if (i < l.size()) {
                URI nextLocation = new URI(diffLocation.getScheme(), diffLocation.getUserInfo(), diffLocation.getHost(), diffLocation.getPort(), diffLocation.getPath(), "pageSize=" + pageSize + "&page=" + (page + 1), diffLocation.getFragment());
                result.put(KEY_NEXT_LOCATION, nextLocation);
            }
            this.writeJSONResponse(request, response, result);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            if (repo != null) {
                repo.close();
            }
        }
    }

    private URI getCloneLocation(URI diffLocation) {
        return null;
    }

    private URI createDiffLocation(URI diffLocation, HttpServletRequest request, String path) throws URISyntaxException {
        if (path == null) {
            return diffLocation;
        }
        IPath diffPath = new Path(request.getContextPath() + "/" + diffLocation.getPath());
        diffPath = diffPath.append(path);
        return new URI(diffLocation.getScheme(), diffLocation.getAuthority(), diffPath.toString(), null, null);
    }

    private URI createContentLocation(URI cloneLocation, DiffEntry entr, String path) throws URISyntaxException {
        return new URI("orion", "hub.jazz.net", "", "");
    }

    private DiffCommand getDiff(HttpServletRequest request, HttpServletResponse response, Repository db, String scope, String pattern, OutputStream out) {
        boolean ignoreWS = Boolean.parseBoolean(request.getParameter("ignoreWS"));
        DiffCommand diff = new DiffCommand(db);
        diff.setOutputStream(out);
        diff.setIgnoreWhiteSpace(ignoreWS);
        AbstractTreeIterator oldTree = null;
        AbstractTreeIterator newTree = null;
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                return null;
            }
            try {
                oldTree = this.getTreeIterator(db, URLDecoder.decode(commits[0], "UTF-8"));
            }
            catch (Exception ex) {
                try {
                    oldTree = new EmptyTreeIterator();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                newTree = this.getTreeIterator(db, URLDecoder.decode(commits[1], "UTF-8"));
            }
            catch (Exception e) {}
        } else {
            try {
                oldTree = this.getTreeIterator(db, scope);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String[] paths = request.getParameterValues(KEY_PATH);
        Object filter = null;
        PathFilter pathFilter = null;
        if (paths != null) {
            if (paths.length > 1) {
                HashSet<PathFilter> pathFilters = new HashSet<PathFilter>(paths.length);
                for (String path : paths) {
                    pathFilters.add(PathFilter.create((String)path));
                }
                pathFilter = OrTreeFilter.create(pathFilters);
            } else if (paths.length == 1) {
                pathFilter = PathFilter.create((String)paths[0]);
            }
        }
        if (pattern != null) {
            PathFilter patternFilter = PathFilter.create((String)pattern);
            filter = pathFilter != null ? AndTreeFilter.create((TreeFilter)patternFilter, (TreeFilter)pathFilter) : patternFilter;
        } else {
            filter = pathFilter;
        }
        if (filter != null) {
            diff.setPathFilter((TreeFilter)filter);
        }
        diff.setOldTree(oldTree);
        if (newTree != null) {
            diff.setNewTree(newTree);
        }
        return diff;
    }

    private void handleAuth(HttpServletRequest req) {
        String username = req.getRemoteUser();
        if (username != null) {
            if (this.config.getBoolean("auth", "userNameToLowerCase", false)) {
                username = username.toLowerCase(Locale.US);
            }
            log.debug("User name: " + username);
            AccountState who = this.accountCache.getByUsername(username);
            log.debug("AccountState " + who);
            if (who == null && username.matches("^([a-zA-Z0-9][a-zA-Z0-9._-]*[a-zA-Z0-9]|[a-zA-Z0-9])$")) {
                log.debug("User is not registered with Gerrit. Register now.");
                AuthRequest areq = AuthRequest.forUser((String)username);
                try {
                    this.accountManager.authenticate(areq);
                    who = this.accountCache.getByUsername(username);
                    if (who == null) {
                        log.warn("Unable to register user \"" + username + "\". Continue as anonymous.");
                    } else {
                        log.debug("User registered.");
                    }
                }
                catch (AccountException e) {
                    log.warn("Exception registering user \"" + username + "\". Continue as anonymous.", (Throwable)e);
                }
            }
            if (who != null && who.getAccount().isActive()) {
                log.debug("Not anonymous user");
                WebSession ws = (WebSession)this.session.get();
                ws.setUserAccountId(who.getAccount().getId());
                ws.setAccessPathOk(AccessPath.REST_API, true);
            } else {
                log.debug("Anonymous user");
            }
        }
    }

    public static String getImageLink(String emailAddress) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(emailAddress.trim().toLowerCase().getBytes());
        byte[] digestValue = digest.digest();
        StringBuffer result = new StringBuffer("https://www.gravatar.com/avatar/");
        for (int i = 0; i < digestValue.length; ++i) {
            String current = Integer.toHexString(digestValue[i] & 0xFF);
            if (current.length() == 1) {
                result.append('0');
            }
            result.append(current);
        }
        result.append("?d=mm");
        return result.toString();
    }

    public static URI getURI(HttpServletRequest request) {
        String path = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (pathInfo != null) {
            path = path + request.getPathInfo();
        }
        try {
            path = URLDecoder.decode(path, "UTF-8");
            return new URI(request.getScheme(), null, path, null, null);
        }
        catch (URISyntaxException e) {
            return null;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractTreeIterator getTreeIterator(Repository db, String name) throws IOException {
        ObjectId id = db.resolve(name);
        if (id == null) {
            throw new IllegalArgumentException(name);
        }
        CanonicalTreeParser p = new CanonicalTreeParser();
        ObjectReader or = db.newObjectReader();
        RevWalk rw = new RevWalk(db);
        try {
            p.reset(or, (AnyObjectId)rw.parseTree((AnyObjectId)id));
            CanonicalTreeParser canonicalTreeParser = p;
            return canonicalTreeParser;
        }
        finally {
            or.release();
            rw.release();
        }
    }
}

