/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.OrgWithSpaces;
import org.eclipse.orion.server.cf.objects.Space;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOrgsCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName = "Get Spaces";

    public GetOrgsCommand(String userId, Target target) {
        super(target);
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            URI orgsURI = targetURI.resolve("/v2/organizations");
            GetMethod getDomainsMethod = new GetMethod(orgsURI.toString());
            HttpUtil.configureHttpMethod((HttpMethod)getDomainsMethod, this.target.getCloud());
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new NameValuePair("inline-relations-depth", "1"));
            if (this.target.getCloud().getRegion() != null) {
                params.add(new NameValuePair("region", this.target.getCloud().getRegion()));
            }
            getDomainsMethod.setQueryString(params.toArray(new NameValuePair[params.size()]));
            ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)getDomainsMethod);
            if (!status.isOK()) {
                return status;
            }
            JSONObject orgs = status.getJsonData();
            if (orgs == null || orgs.optInt("total_results", 0) < 1) {
                return new ServerStatus(4, 204, "Server did not return any organizations.", null);
            }
            JSONObject result = new JSONObject();
            int resources = orgs.getJSONArray("resources").length();
            int k = 0;
            while (k < resources) {
                ArrayList<Space> spaces = new ArrayList<Space>();
                JSONObject orgJSON = orgs.getJSONArray("resources").getJSONObject(k);
                status = this.getSpaces(spaces, orgJSON);
                if (!status.isOK()) {
                    return status;
                }
                OrgWithSpaces orgWithSpaces = new OrgWithSpaces();
                orgWithSpaces.setCFJSON(orgJSON);
                orgWithSpaces.setSpaces(spaces);
                result.append("Orgs", (Object)orgWithSpaces.toJSON());
                ++k;
            }
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        catch (ConnectTimeoutException e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 504, msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occurred when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }

    private ServerStatus getSpaces(List<Space> spaces, JSONObject orgJSON) throws Exception {
        long time = System.currentTimeMillis();
        URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
        URI spaceURI = targetURI.resolve(orgJSON.getJSONObject("entity").getString("spaces_url"));
        GetMethod getDomainsMethod = new GetMethod(spaceURI.toString());
        HttpUtil.configureHttpMethod((HttpMethod)getDomainsMethod, this.target.getCloud());
        getDomainsMethod.setQueryString("inline-relations-depth=1");
        ServerStatus status = HttpUtil.executeMethod((HttpMethodBase)getDomainsMethod);
        if (!status.isOK()) {
            return status;
        }
        JSONObject orgs = status.getJsonData();
        if (orgs.getInt("total_results") < 1) {
            return new ServerStatus(Status.OK_STATUS, 200);
        }
        int resources = orgs.getJSONArray("resources").length();
        int k = 0;
        while (k < resources) {
            JSONObject spaceJSON = orgs.getJSONArray("resources").getJSONObject(k);
            spaces.add(new Space().setCFJSON(spaceJSON));
            ++k;
        }
        this.logger.debug("GetOrgsCommand: getting spaces using " + spaceURI + " took " + (System.currentTimeMillis() - time));
        return new ServerStatus(Status.OK_STATUS, 200);
    }
}

