/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.commands.ComputeTargetCommand;
import org.eclipse.orion.server.cf.commands.GetAppByGuidCommand;
import org.eclipse.orion.server.cf.commands.GetAppCommand;
import org.eclipse.orion.server.cf.commands.GetRouteByGuidCommand;
import org.eclipse.orion.server.cf.commands.MapRouteCommand;
import org.eclipse.orion.server.cf.commands.ParseManifestCommand;
import org.eclipse.orion.server.cf.commands.ParseManifestJSONCommand;
import org.eclipse.orion.server.cf.commands.PushAppCommand;
import org.eclipse.orion.server.cf.commands.RestartAppCommand;
import org.eclipse.orion.server.cf.commands.StartAppCommand;
import org.eclipse.orion.server.cf.commands.StopAppCommand;
import org.eclipse.orion.server.cf.commands.UnmapRouteCommand;
import org.eclipse.orion.server.cf.ds.IDeploymentPackager;
import org.eclipse.orion.server.cf.ds.IDeploymentService;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.manifest.v2.InvalidAccessException;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.manifest.v2.utils.ManifestUtils;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.App2;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppsHandlerV1
extends AbstractRESTHandler<App> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public AppsHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected App buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(App app, HttpServletRequest request, HttpServletResponse response, final String path) {
        final String encodedContentLocation = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"ContentLocation");
        String contentLocation = null;
        if (encodedContentLocation != null) {
            try {
                contentLocation = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)URLDecoder.decode(encodedContentLocation, "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        final String finalContentLocation = contentLocation;
        final String encodedName = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Name");
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus result = computeTarget.doIt();
                    if (!result.isOK()) {
                        return result;
                    }
                    Target target = computeTarget.getTarget();
                    if (encodedName != null) {
                        String name = URLDecoder.decode(encodedName, "UTF8");
                        return new GetAppCommand(target, name).doIt();
                    }
                    if (encodedContentLocation != null) {
                        ManifestParseTree applications;
                        if (finalContentLocation == null) {
                            return new ServerStatus(4, 404, "Can not determine the application name", null);
                        }
                        String manifestAppName = null;
                        ParseManifestCommand parseManifestCommand = new ParseManifestCommand(target, this.userId, finalContentLocation);
                        IStatus status = parseManifestCommand.doIt();
                        if (!status.isOK()) {
                            return status;
                        }
                        ManifestParseTree manifest = parseManifestCommand.getManifest();
                        if (manifest != null && (applications = manifest.get("applications")).getChildren().size() > 0) {
                            manifestAppName = applications.get(0).get("name").getValue();
                            return new GetAppCommand(target, manifestAppName).doIt();
                        }
                        return new ServerStatus(4, 404, "Can not determine the application name", null);
                    }
                    return AppsHandlerV1.this.getApps(target);
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    @Override
    protected CFJob handlePut(App resource, HttpServletRequest request, HttpServletResponse response, final String pathString) {
        String routeGuid;
        final JSONObject targetJSON2 = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        Path path = pathString != null ? new Path(pathString) : new Path("");
        final String appGuid = path.segment(0);
        boolean addRoute = "routes".equals(path.segment(1));
        String string = routeGuid = addRoute ? path.segment(2) : null;
        if (addRoute) {
            return new CFJob(request, false){

                protected IStatus performJob() {
                    try {
                        ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON2);
                        IStatus status = computeTarget.doIt();
                        if (!status.isOK()) {
                            return status;
                        }
                        Target target = computeTarget.getTarget();
                        GetAppByGuidCommand getAppByGuid = new GetAppByGuidCommand(target.getCloud(), appGuid);
                        IStatus getAppByGuidStatus = getAppByGuid.doIt();
                        if (!getAppByGuidStatus.isOK()) {
                            return getAppByGuidStatus;
                        }
                        App app = getAppByGuid.getApp();
                        GetRouteByGuidCommand getRouteByGuid = new GetRouteByGuidCommand(target.getCloud(), routeGuid);
                        IStatus getRouteByGuidStatus = getRouteByGuid.doIt();
                        if (!getRouteByGuidStatus.isOK()) {
                            return getRouteByGuidStatus;
                        }
                        Route route = getRouteByGuid.getRoute();
                        MapRouteCommand unmapRoute = new MapRouteCommand(target, app, route.getGuid());
                        return unmapRoute.doIt();
                    }
                    catch (Exception e) {
                        String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)pathString);
                        ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                        AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                        return status;
                    }
                }
            };
        }
        JSONObject jsonData = this.extractJSONData(request);
        final JSONObject targetJSON = jsonData.optJSONObject("Target");
        final String state = jsonData.optString("State", null);
        final String appName = jsonData.optString("Name", null);
        final String contentLocation = ServletResourceHandler.toOrionLocation((HttpServletRequest)request, (String)jsonData.optString("ContentLocation", null));
        final String packagerName = jsonData.optString("Packager", null);
        final JSONObject manifestJSON = jsonData.optJSONObject("Manifest");
        final JSONObject instrumentationJSON = jsonData.optJSONObject("Instrumentation");
        int userTimeout = jsonData.optInt("Timeout", 60);
        final int timeout = userTimeout > 0 ? userTimeout : 0;
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus status = computeTarget.doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    Target target = computeTarget.getTarget();
                    String manifestAppName = null;
                    ManifestParseTree manifest = null;
                    IFileStore appStore = null;
                    if (contentLocation != null && state == null) {
                        ManifestParseTree applications;
                        if (manifestJSON != null) {
                            ParseManifestJSONCommand parseManifestJSONCommand = new ParseManifestJSONCommand(manifestJSON, this.userId, contentLocation);
                            status = parseManifestJSONCommand.doIt();
                            if (!status.isOK()) {
                                return status;
                            }
                            manifest = parseManifestJSONCommand.getManifest();
                            appStore = parseManifestJSONCommand.getAppStore();
                        } else {
                            ParseManifestCommand parseManifestCommand = new ParseManifestCommand(target, this.userId, contentLocation);
                            status = parseManifestCommand.doIt();
                            if (!status.isOK()) {
                                return status;
                            }
                            manifest = parseManifestCommand.getManifest();
                            appStore = parseManifestCommand.getAppStore();
                        }
                        if (manifest != null && (applications = manifest.get("applications")).getChildren().size() > 0 && applications.get(0).has("name")) {
                            manifestAppName = applications.get(0).get("name").getValue();
                        }
                    }
                    GetAppCommand getAppCommand = new GetAppCommand(target, appName != null ? appName : manifestAppName);
                    status = getAppCommand.doIt();
                    App app = getAppCommand.getApp();
                    if ("Started".equals(state)) {
                        if (!status.isOK()) {
                            return status;
                        }
                        return new StartAppCommand(target, app, timeout).doIt();
                    }
                    if ("Stopped".equals(state)) {
                        if (!status.isOK()) {
                            return status;
                        }
                        return new StopAppCommand(target, app).doIt();
                    }
                    if (manifest == null) {
                        String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)pathString);
                        status = new ServerStatus(4, 500, msg, null);
                        AppsHandlerV1.this.logger.error(msg);
                        return status;
                    }
                    boolean restart = true;
                    if (app == null) {
                        app = new App();
                        restart = false;
                    }
                    String command = AppsHandlerV1.this.findCommand(manifest);
                    ManifestUtils.instrumentManifest(manifest, instrumentationJSON);
                    app.setName(appName != null ? appName : manifestAppName);
                    app.setManifest(manifest);
                    IDeploymentService deploymentService = CFActivator.getDefault().getDeploymentService();
                    IDeploymentPackager packager = deploymentService.getDeploymentPackager(packagerName);
                    if (packager == null) {
                        packager = deploymentService.getDefaultDeplomentPackager();
                    }
                    if (!(status = new PushAppCommand(target, app, appStore, packager, command).doIt()).isOK()) {
                        return status;
                    }
                    getAppCommand = new GetAppCommand(target, app.getName());
                    getAppCommand.doIt();
                    app = getAppCommand.getApp();
                    app.setManifest(manifest);
                    ServerStatus startStatus = null;
                    startStatus = restart ? (ServerStatus)new RestartAppCommand(target, app).doIt() : (ServerStatus)new StartAppCommand(target, app).doIt();
                    if (startStatus.getSeverity() == 4) {
                        return startStatus;
                    }
                    return status;
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)pathString);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    protected String findCommand(ManifestParseTree manifestTree) throws JSONException {
        String command = null;
        try {
            ManifestParseTree applications = manifestTree.get("applications");
            ManifestParseTree application = applications.get(0);
            command = application.get("command").getValue();
        }
        catch (InvalidAccessException invalidAccessException) {
            return null;
        }
        return command;
    }

    @Override
    protected CFJob handleDelete(App resource, HttpServletRequest request, HttpServletResponse response, final String pathString) {
        final JSONObject targetJSON = this.extractJSONData(IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Target"));
        Path path = new Path(pathString);
        final String appGuid = path.segment(0);
        boolean deleteRoute = "routes".equals(path.segment(1));
        final String routeGuid = deleteRoute ? path.segment(2) : null;
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ComputeTargetCommand computeTarget = new ComputeTargetCommand(this.userId, targetJSON);
                    IStatus status = computeTarget.doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    Target target = computeTarget.getTarget();
                    GetAppByGuidCommand getAppByGuid = new GetAppByGuidCommand(target.getCloud(), appGuid);
                    IStatus getAppByGuidStatus = getAppByGuid.doIt();
                    if (!getAppByGuidStatus.isOK()) {
                        return getAppByGuidStatus;
                    }
                    App app = getAppByGuid.getApp();
                    GetRouteByGuidCommand getRouteByGuid = new GetRouteByGuidCommand(target.getCloud(), routeGuid);
                    IStatus getRouteByGuidStatus = getRouteByGuid.doIt();
                    if (!getRouteByGuidStatus.isOK()) {
                        return getRouteByGuidStatus;
                    }
                    Route route = getRouteByGuid.getRoute();
                    UnmapRouteCommand unmapRoute = new UnmapRouteCommand(target, app, route);
                    return unmapRoute.doIt();
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)pathString);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    AppsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }

    private IStatus getApps(Target target) throws Exception {
        String appsUrl = target.getSpace().getCFJSON().getJSONObject("entity").getString("apps_url");
        URI appsURI = URIUtil.toURI((URL)target.getUrl()).resolve(appsUrl);
        GetMethod getAppsMethod = new GetMethod(appsURI.toString());
        HttpUtil.configureHttpMethod((HttpMethod)getAppsMethod, target.getCloud());
        getAppsMethod.setQueryString("inline-relations-depth=2");
        ServerStatus getAppsStatus = HttpUtil.executeMethod((HttpMethodBase)getAppsMethod);
        if (!getAppsStatus.isOK()) {
            return getAppsStatus;
        }
        JSONObject appsJSON = getAppsStatus.getJsonData();
        JSONObject result = new JSONObject();
        result.put("Apps", (Object)new JSONArray());
        if (appsJSON.getInt("total_results") < 1) {
            return new ServerStatus(Status.OK_STATUS, 200, result);
        }
        JSONArray resources = appsJSON.getJSONArray("resources");
        int k = 0;
        while (k < resources.length()) {
            JSONObject appJSON = resources.getJSONObject(k);
            App2 app = new App2();
            app.setCFJSON(appJSON);
            result.append("Apps", (Object)app.toJSON());
            ++k;
        }
        return new ServerStatus(Status.OK_STATUS, 200, result);
    }
}

