/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URI;
import java.net.URL;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.PutMethod;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.orion.server.cf.commands.AbstractCFCommand;
import org.eclipse.orion.server.cf.objects.App;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouteCommand
extends AbstractCFCommand {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");
    private String commandName;
    private App application;
    private String routeGUID;

    public MapRouteCommand(Target target, App app, String routeGUID) {
        super(target);
        Object[] bindings = new String[]{routeGUID, app.getName(), app.getGuid()};
        this.commandName = NLS.bind((String)"Attach route (guid: {0}) to application {1} (guid: {2})", (Object[])bindings);
        this.application = app;
        this.routeGUID = routeGUID;
    }

    @Override
    protected ServerStatus _doIt() {
        try {
            URI targetURI = URIUtil.toURI((URL)this.target.getUrl());
            PutMethod attachRouteMethod = new PutMethod(targetURI.resolve("/v2/apps/" + this.application.getGuid() + "/routes/" + this.routeGUID).toString());
            HttpUtil.configureHttpMethod((HttpMethod)attachRouteMethod, this.target.getCloud());
            return HttpUtil.executeMethod((HttpMethodBase)attachRouteMethod);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when performing operation {0}", (Object)this.commandName);
            this.logger.error(msg, (Throwable)e);
            return new ServerStatus(4, 500, msg, (Throwable)e);
        }
    }
}

