/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.handlers.v1;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.cf.commands.ParseManifestCommand;
import org.eclipse.orion.server.cf.jobs.CFJob;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;
import org.eclipse.orion.server.cf.objects.Manifest;
import org.eclipse.orion.server.cf.servlets.AbstractRESTHandler;
import org.eclipse.orion.server.core.IOUtilities;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestsHandlerV1
extends AbstractRESTHandler<Manifest> {
    private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.cf");

    public ManifestsHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected Manifest buildResource(HttpServletRequest request, String path) throws CoreException {
        return null;
    }

    @Override
    protected CFJob handleGet(Manifest manifest, HttpServletRequest request, HttpServletResponse response, final String path) {
        String strictString = IOUtilities.getQueryParameter((HttpServletRequest)request, (String)"Strict");
        final boolean strict = strictString != null ? Boolean.parseBoolean(strictString) : false;
        return new CFJob(request, false){

            protected IStatus performJob() {
                try {
                    ParseManifestCommand parseManifestCommand = new ParseManifestCommand(null, this.userId, path);
                    parseManifestCommand.setStrict(strict);
                    IStatus status = parseManifestCommand.doIt();
                    if (!status.isOK()) {
                        return status;
                    }
                    ManifestParseTree manifest = parseManifestCommand.getManifest();
                    Manifest resp = new Manifest(manifest);
                    return new ServerStatus(Status.OK_STATUS, 200, resp.toJSON());
                }
                catch (Exception e) {
                    String msg = NLS.bind((String)"Failed to handle request for {0}", (Object)path);
                    ServerStatus status = new ServerStatus(4, 500, msg, (Throwable)e);
                    ManifestsHandlerV1.this.logger.error(msg, (Throwable)e);
                    return status;
                }
            }
        };
    }
}

