/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets;

import java.io.File;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.orion.internal.server.core.metastore.SimpleMetaStoreUtil;
import org.eclipse.orion.internal.server.servlets.workspace.ProjectParentDecorator;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.internal.server.servlets.xfer.TransferResourceDecorator;
import org.eclipse.orion.server.authentication.IAuthenticationService;
import org.eclipse.orion.server.authentication.NoneAuthenticationService;
import org.eclipse.orion.server.core.IWebResourceDecorator;
import org.eclipse.orion.server.core.LogHelper;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String ADMIN_LOGIN_VALUE = "admin";
    private static final String ADMIN_NAME_VALUE = "Administrative User";
    public static volatile BundleContext bundleContext;
    public static final boolean DEBUG = true;
    public static final String LOCATION_FILE_SERVLET = "/file";
    public static final String LOCATION_WORKSPACE_SERVLET = "/workspace";
    public static final String PI_SERVER_SERVLETS = "org.eclipse.orion.server.servlets";
    public static final String PROP_USER_AREA = "org.eclipse.orion.server.core.userArea";
    public static final String DEFAULT_AUTHENTICATION_NAME = "FORM+OAuth";
    static final String PROP_CONFIGURED = "configured";
    static Activator singleton;
    private ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> decoratorTracker;
    private ServiceRegistration<IWebResourceDecorator> transferDecoratorRegistration;
    private ServiceRegistration<IWebResourceDecorator> parentDecoratorRegistration;
    private AuthServiceTracker authServiceTracker;

    public static Activator getDefault() {
        return singleton;
    }

    public BundleContext getContext() {
        return bundleContext;
    }

    private synchronized ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> getDecoratorTracker() {
        if (this.decoratorTracker == null) {
            this.decoratorTracker = new ServiceTracker(bundleContext, IWebResourceDecorator.class, null);
            this.decoratorTracker.open();
        }
        return this.decoratorTracker;
    }

    public Collection<IWebResourceDecorator> getWebResourceDecorators() {
        ServiceTracker<IWebResourceDecorator, IWebResourceDecorator> tracker = this.getDecoratorTracker();
        return tracker.getTracked().values();
    }

    private void registerServices() {
        this.transferDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new TransferResourceDecorator(), null);
        this.parentDecoratorRegistration = bundleContext.registerService(IWebResourceDecorator.class, (Object)new ProjectParentDecorator(), null);
    }

    public void start(BundleContext context) throws Exception {
        singleton = this;
        bundleContext = context;
        this.registerServices();
        this.authServiceTracker = new AuthServiceTracker(context);
        this.authServiceTracker.open();
        this.initializeAdminUser();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.authServiceTracker != null) {
            this.authServiceTracker.close();
            this.authServiceTracker = null;
        }
        if (this.decoratorTracker != null) {
            this.decoratorTracker.close();
            this.decoratorTracker = null;
        }
        this.unregisterServices();
        bundleContext = null;
    }

    private void unregisterServices() {
        if (this.transferDecoratorRegistration != null) {
            this.transferDecoratorRegistration.unregister();
            this.transferDecoratorRegistration = null;
        }
        if (this.parentDecoratorRegistration != null) {
            this.parentDecoratorRegistration.unregister();
            this.parentDecoratorRegistration = null;
        }
    }

    public IAuthenticationService getAuthService() {
        return (IAuthenticationService)this.authServiceTracker.getService();
    }

    String getAuthName() {
        return PreferenceHelper.getString((String)"orion.auth.name", (String)System.getProperty("orion.tests.authtype", DEFAULT_AUTHENTICATION_NAME));
    }

    Filter getAuthFilter() throws InvalidSyntaxException {
        StringBuilder sb = new StringBuilder("(");
        sb.append("orion.auth.name");
        sb.append('=');
        sb.append(this.getAuthName());
        sb.append(')');
        return FrameworkUtil.createFilter((String)sb.toString());
    }

    private void initializeAdminUser() {
        block5: {
            try {
                String adminDefaultPassword = PreferenceHelper.getString((String)"orion.auth.admin.default.password");
                Boolean adminUserFolderExists = SimpleMetaStoreUtil.readMetaUserFolder((File)OrionConfiguration.getRootLocation().toLocalFile(0, null), (String)ADMIN_LOGIN_VALUE).exists();
                if (adminUserFolderExists.booleanValue() || adminDefaultPassword == null) break block5;
                UserInfo userInfo = new UserInfo();
                userInfo.setUserName(ADMIN_LOGIN_VALUE);
                userInfo.setFullName(ADMIN_NAME_VALUE);
                userInfo.setProperty("Password", adminDefaultPassword);
                OrionConfiguration.getMetaStore().createUser(userInfo);
                try {
                    AuthorizationService.addUserRight(ADMIN_LOGIN_VALUE, "/users");
                    AuthorizationService.addUserRight(ADMIN_LOGIN_VALUE, "/users/*");
                }
                catch (CoreException e) {
                    LogHelper.log((Throwable)e);
                }
                Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.account");
                if (logger.isInfoEnabled()) {
                    logger.info("Account created: admin");
                }
            }
            catch (CoreException e) {
                LogHelper.log((Throwable)e);
            }
        }
    }

    private class AuthServiceTracker
    extends ServiceTracker<IAuthenticationService, IAuthenticationService> {
        public AuthServiceTracker(BundleContext context) throws InvalidSyntaxException {
            super(context, Activator.this.getAuthFilter(), null);
            if ("None".equalsIgnoreCase(Activator.this.getAuthName())) {
                Hashtable<String, String> properties = new Hashtable<String, String>();
                ((Dictionary)properties).put("orion.auth.name", Activator.this.getAuthName());
                context.registerService(IAuthenticationService.class, (Object)new NoneAuthenticationService(), properties);
            }
        }

        public IAuthenticationService addingService(ServiceReference<IAuthenticationService> reference) {
            if ("true".equals(reference.getProperty(Activator.PROP_CONFIGURED))) {
                return null;
            }
            IAuthenticationService authService = (IAuthenticationService)super.addingService(reference);
            Properties dictionary = new Properties();
            ((Dictionary)dictionary).put(Activator.PROP_CONFIGURED, "true");
            if (this.getService() != null) {
                ((IAuthenticationService)this.getService()).setRegistered(false);
            }
            authService.setRegistered(true);
            this.context.registerService(IAuthenticationService.class.getName(), (Object)authService, (Dictionary)dictionary);
            return authService;
        }
    }
}

