/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.jobs;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.git.jobs.GitJob;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusJob
extends GitJob {
    private static final int GIT_PERF_THRESHOLD = 10000;
    private IPath filePath;
    private URI baseLocation;

    public StatusJob(String userRunningTask, Path filePath, URI baseLocation) {
        super(userRunningTask, false);
        this.filePath = filePath;
        this.baseLocation = baseLocation;
    }

    protected IStatus performJob() {
        Logger logger = LoggerFactory.getLogger((String)"org.eclipse.orion.server.git");
        Repository db = null;
        try {
            long t0 = System.currentTimeMillis();
            Set<Map.Entry<IPath, File>> set = GitUtils.getGitDirs(this.filePath, GitUtils.Traverse.GO_UP).entrySet();
            File gitDir = set.iterator().next().getValue();
            if (gitDir == null) {
                logger.error("***** Git status failed to find Git directory for request: " + this.filePath);
                String msg = NLS.bind((String)"Could not find repository for {0}", (Object)this.filePath);
                ServerStatus serverStatus = new ServerStatus(4, 400, msg, null);
                return serverStatus;
            }
            long t1 = System.currentTimeMillis();
            db = FileRepositoryBuilder.create((File)gitDir);
            Git git = new Git(db);
            org.eclipse.jgit.api.Status gitStatus = git.status().call();
            long t2 = System.currentTimeMillis();
            String relativePath = GitUtils.getRelativePath(this.filePath, set.iterator().next().getKey());
            Path basePath = new Path(relativePath);
            org.eclipse.orion.server.git.objects.Status status = new org.eclipse.orion.server.git.objects.Status(this.baseLocation, db, gitStatus, (IPath)basePath);
            ServerStatus result = new ServerStatus(Status.OK_STATUS, 200, status.toJSON());
            if (logger.isDebugEnabled() && t2 - t0 > 10000L) {
                logger.debug("Slow git status. Finding git dir: " + (t1 - t0) + "ms. JGit status call: " + (t2 - t1) + "ms");
            }
            ServerStatus serverStatus = result;
            return serverStatus;
        }
        catch (Exception e) {
            String msg = NLS.bind((String)"An error occured when generating status for ref {0}", (Object)this.filePath);
            Status status = new Status(4, "org.eclipse.orion.server.git", msg, (Throwable)e);
            return status;
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }
}

