/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.commands;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.orion.server.cf.CFActivator;
import org.eclipse.orion.server.cf.ExpiryCache;
import org.eclipse.orion.server.cf.commands.ICFCommand;
import org.eclipse.orion.server.cf.commands.SetOrgCommand;
import org.eclipse.orion.server.cf.commands.SetSpaceCommand;
import org.eclipse.orion.server.cf.objects.Target;
import org.eclipse.orion.server.cf.utils.HttpUtil;
import org.eclipse.orion.server.core.ServerStatus;
import org.json.JSONObject;

public class ComputeTargetCommand
implements ICFCommand {
    private String userId;
    private JSONObject targetJSON;
    private Target target;
    private static final int CACHE_EXPIRES_MS = 1800000;
    private static final int MAX_CACHE_SIZE = 10000;
    static ExpiryCache<Target> targetCache = new ExpiryCache(10000, 1800000);

    public ComputeTargetCommand(String userId, JSONObject targetJSON) {
        this.userId = userId;
        this.targetJSON = targetJSON;
    }

    @Override
    public IStatus doIt() {
        URL targetUrl = null;
        String org = null;
        String space = null;
        if (this.targetJSON != null) {
            try {
                targetUrl = new URL(this.targetJSON.getString("Url"));
                org = this.targetJSON.optString("Org");
                space = this.targetJSON.optString("Space");
            }
            catch (Exception exception) {}
        }
        if (targetUrl != null && org != null && space != null) {
            List<Object> key = Arrays.asList(this.userId, targetUrl, org, space);
            this.target = targetCache.get(key);
            if (this.target != null) {
                return new ServerStatus(Status.OK_STATUS, 200);
            }
        }
        this.target = CFActivator.getDefault().getTargetRegistry().getTarget(this.userId, targetUrl);
        if (this.target == null) {
            return HttpUtil.createErrorStatus(2, "CF-TargetNotSet", "Target not set");
        }
        IStatus result = new SetOrgCommand(this.target, org).doIt();
        if (!result.isOK()) {
            return result;
        }
        result = new SetSpaceCommand(this.target, space).doIt();
        if (!result.isOK()) {
            return result;
        }
        List<Object> key = Arrays.asList(this.userId, this.target.getUrl(), this.target.getOrg().getName(), this.target.getSpace().getName());
        targetCache.put(key, this.target);
        return new ServerStatus(Status.OK_STATUS, 200);
    }

    public Target getTarget() {
        return this.target;
    }
}

