/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.captcha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.scada.utils.ExceptionHelper;

public interface CaptchaResult {
    public static final CaptchaResult OK = new CaptchaResult(){

        @Override
        public List<String> getErrorMessages() {
            return Collections.emptyList();
        }
    };

    public List<String> getErrorMessages();

    default public boolean isSuccess() {
        return this.getErrorMessages().isEmpty();
    }

    public static CaptchaResult errorResult(Collection<String> messages) {
        return CaptchaResult.errorResult(new ArrayList<String>(messages));
    }

    public static CaptchaResult errorResult(final List<String> messages) {
        return new CaptchaResult(){

            @Override
            public List<String> getErrorMessages() {
                return messages;
            }
        };
    }

    public static CaptchaResult errorResult(String ... messages) {
        return CaptchaResult.errorResult(Arrays.asList(messages));
    }

    public static CaptchaResult exceptionResult(Throwable error) {
        String message = String.format("Captcha error: %s", ExceptionHelper.getMessage((Throwable)error));
        return CaptchaResult.errorResult(message);
    }
}

