/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.profiler;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.packagedrone.utils.ProcessUtil;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.eclipse.packagedrone.utils.profiler.ProfileDataHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlProfileDataHandler
implements ProfileDataHandler {
    private static final Logger logger = LoggerFactory.getLogger(XmlProfileDataHandler.class);
    private static char[] whitespaces = "                                                            ".toCharArray();
    private final Path dir;
    private final AtomicInteger counter = new AtomicInteger();
    private final Long pid;

    public XmlProfileDataHandler(Path dir) {
        this.dir = dir;
        this.pid = ProcessUtil.getProcessId();
        if (this.pid == null) {
            throw new IllegalStateException(String.format("Unable to evaluate current process ID", new Object[0]));
        }
        logger.warn("Activating XML profile data handler: {}/{}", (Object)dir, (Object)this.pid);
    }

    private Path makeNextName() throws IOException {
        if (!Files.exists(this.dir, new LinkOption[0]) && Files.exists(this.dir.getParent(), new LinkOption[0])) {
            Files.createDirectory(this.dir, new FileAttribute[0]);
        }
        return this.dir.resolve(String.format("pid%d-%08d.xml", this.pid, this.counter.getAndIncrement()));
    }

    @Override
    public void handle(Profile.DurationEntry entry) {
        try {
            XMLOutputFactory xml = XMLOutputFactory.newInstance();
            Path name = this.makeNextName();
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(name, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));){
                XMLStreamWriter xsw = xml.createXMLStreamWriter(stream);
                xsw.writeStartDocument();
                xsw.writeCharacters("\n\n");
                xsw.writeStartElement("trace");
                xsw.writeDefaultNamespace("http://packagedrone.org/profile/trace/v1.0");
                xsw.writeCharacters("\n");
                this.dumpEntry(xsw, entry, 1);
                xsw.writeEndElement();
                xsw.writeCharacters("\n");
                xsw.writeEndDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!Boolean.getBoolean("drone.profile.xml.disableAnnounce")) {
                System.out.format("Wrote profile trace: %s ms - %s -> %s%n", entry.getDuration().toMillis(), entry.getOperation(), name.toAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to write profile trace", (Throwable)e);
        }
    }

    private void dumpEntry(XMLStreamWriter xsw, Profile.DurationEntry entry, int level) throws XMLStreamException {
        this.indent(xsw, level);
        boolean empty = entry.getEntries().isEmpty();
        if (empty) {
            xsw.writeEmptyElement("operation");
        } else {
            xsw.writeStartElement("operation");
        }
        xsw.writeAttribute("name", entry.getOperation());
        xsw.writeAttribute("duration", "" + entry.getDuration().toMillis());
        if (!empty) {
            xsw.writeCharacters("\n");
            this.dumpEntries(xsw, entry.getEntries(), level + 1);
            this.indent(xsw, level);
            xsw.writeEndElement();
        }
        xsw.writeCharacters("\n");
    }

    private void indent(XMLStreamWriter xsw, int level) throws XMLStreamException {
        xsw.writeCharacters(whitespaces, 0, Math.min(whitespaces.length, level * 2));
    }

    private void dumpEntries(XMLStreamWriter xsw, List<Profile.DurationEntry> entries, int level) throws XMLStreamException {
        for (Profile.DurationEntry entry : entries) {
            this.dumpEntry(xsw, entry, level);
        }
    }
}

