/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.web;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.manage.system.web.BundleInformation;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;

@Controller
@ViewResolver(value="/WEB-INF/views/info/framework/%s.jsp")
@RequestMapping(value={"/system/info/framework"})
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class FrameworkInformationController
implements InterfaceExtender {
    private final BundleContext context = FrameworkUtil.getBundle(FrameworkInformationController.class).getBundleContext();

    @RequestMapping
    public ModelAndView view() {
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("vendor", System.getProperty("org.osgi.framework.vendor"));
        model.put("version", System.getProperty("org.osgi.framework.version"));
        Bundle sysBundle = this.context.getBundle(0L);
        if (sysBundle != null) {
            model.put("sysSymbolicName", sysBundle.getSymbolicName());
            model.put("sysName", (String)sysBundle.getHeaders(null).get("Bundle-Name"));
        }
        return new ModelAndView("index", model);
    }

    @RequestMapping(value={"/bundles"})
    public ModelAndView bundles() {
        HashMap model = new HashMap();
        Bundle[] bundles = this.context.getBundles();
        Arrays.sort(bundles, Comparator.comparing(Bundle::getSymbolicName));
        model.put("bundles", Arrays.stream(bundles).map(BundleInformation::new).collect(Collectors.toList()));
        return new ModelAndView("bundles", model);
    }

    @RequestMapping(value={"/bundles/{id}/start"}, method={RequestMethod.POST})
    public ModelAndView startBundle(@PathVariable(value="id") long bundleId) throws BundleException {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle != null) {
            bundle.start();
        }
        return new ModelAndView("redirect:/system/info/framework/bundles");
    }

    @RequestMapping(value={"/bundles/{id}/stop"}, method={RequestMethod.POST})
    public ModelAndView stopBundle(@PathVariable(value="id") long bundleId) throws BundleException {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle != null) {
            bundle.stop();
        }
        return new ModelAndView("redirect:/system/info/framework/bundles");
    }

    @RequestMapping(value={"/bundles/{id}/about.html"}, method={RequestMethod.GET})
    public void showAbout(@PathVariable(value="id") long bundleId, HttpServletResponse response) throws IOException {
        this.showBundleFile(bundleId, response, "about.html", "text/html");
    }

    @RequestMapping(value={"/bundles/{id}/LICENSE.txt"}, method={RequestMethod.GET})
    public void showLicenseTxt(@PathVariable(value="id") long bundleId, HttpServletResponse response) throws IOException {
        this.showBundleFile(bundleId, response, "META-INF/LICENSE.txt", "text/plain");
    }

    @RequestMapping(value={"/bundles/{id}/NOTICE.txt"}, method={RequestMethod.GET})
    public void showNoticeTxt(@PathVariable(value="id") long bundleId, HttpServletResponse response) throws IOException {
        this.showBundleFile(bundleId, response, "META-INF/NOTICE.txt", "text/plain");
    }

    private void showBundleFile(long bundleId, HttpServletResponse response, String file, String mimeType) throws IOException {
        Bundle bundle = this.context.getBundle(bundleId);
        if (bundle == null) {
            response.sendError(404, "Bundle not found");
            return;
        }
        URL about = bundle.getEntry(file);
        if (about == null) {
            response.sendError(404, String.format("'%s' not found", file));
            return;
        }
        response.setContentType(mimeType);
        Throwable throwable = null;
        Object var9_9 = null;
        try (InputStream in = about.openStream();){
            ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (request.isUserInRole("ADMIN")) {
            result.add(new MenuEntry("System", Integer.MAX_VALUE, "OSGi Framework", 1000, LinkTarget.createFromController(FrameworkInformationController.class, (String)"view"), Modifier.DEFAULT, "cog"));
        }
        return result;
    }
}

