/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.http;

import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTrigger;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactory;
import org.eclipse.packagedrone.repo.trigger.http.HttpTrigger;
import org.eclipse.packagedrone.repo.trigger.http.HttpTriggerConfiguration;
import org.eclipse.packagedrone.repo.trigger.http.HttpTriggerController;
import org.eclipse.packagedrone.web.LinkTarget;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTriggerFactory
implements ConfiguredTriggerFactory {
    static final String DESCRIPTION = "This trigger will provide an HTTP endpoint which activates the trigger when getting called";
    static final String LABEL = "HTTP endpoint trigger";
    private static final Logger logger = LoggerFactory.getLogger(HttpTriggerFactory.class);
    public static final String ID = "http.endpoint";
    private HttpService httpService;
    private SitePrefixService sitePrefixService;
    private ChannelService channelService;

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setSitePrefixService(SitePrefixService sitePrefixService) {
        this.sitePrefixService = sitePrefixService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public ConfiguredTrigger create(String configuration) {
        return new HttpTrigger(this.sitePrefixService, this.httpService, HttpTriggerConfiguration.fromJson(configuration), this.channelService);
    }

    public String getLabel() {
        return LABEL;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getConfigurationUrl() {
        try {
            return LinkTarget.createFromController(HttpTriggerController.class, (String)"configure").getUrl();
        }
        catch (Exception e) {
            logger.warn("Failed to generate configuration url", (Throwable)e);
            return null;
        }
    }
}

