/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.LongSerializationPolicy;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.apm.ChannelModel;
import org.eclipse.packagedrone.repo.channel.apm.ChannelReader;
import org.eclipse.packagedrone.repo.channel.apm.ChannelWriter;
import org.eclipse.packagedrone.repo.channel.apm.ModifyContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.internal.Finally;
import org.eclipse.packagedrone.repo.channel.apm.store.BlobStore;
import org.eclipse.packagedrone.repo.channel.apm.store.CacheStore;
import org.eclipse.packagedrone.repo.channel.provider.AccessContext;
import org.eclipse.packagedrone.storage.apm.AbstractSimpleStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.util.ReplaceOnCloseOutputStream;
import org.eclipse.packagedrone.utils.Suppressed;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelModelProvider
extends AbstractSimpleStorageModelProvider<AccessContext, ModifyContextImpl> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelModelProvider.class);
    private final String channelId;
    private BlobStore store;
    private CacheStore cacheStore;
    private final String dir;
    static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public ChannelModelProvider(String channelId, String dir) {
        super(AccessContext.class, ModifyContextImpl.class);
        this.channelId = channelId;
        this.dir = dir;
    }

    public void start(StorageContext context) throws Exception {
        this.store = new BlobStore(ChannelModelProvider.makeBasePath(context, this.dir).resolve("blobs"));
        this.cacheStore = new CacheStore(ChannelModelProvider.makeBasePath(context, this.dir).resolve("cache"));
        super.start(context);
    }

    public void stop() {
        super.stop();
        this.store.close();
        this.cacheStore.close();
    }

    protected AccessContext makeViewModelTyped(ModifyContextImpl writeModel) {
        return writeModel;
    }

    protected ModifyContextImpl cloneWriteModel(ModifyContextImpl writeModel) {
        return new ModifyContextImpl(writeModel);
    }

    public static Path makeBasePath(StorageContext context, String dir) {
        return context.getBasePath().resolve(Paths.get("channels", dir));
    }

    public static Path makeStatePath(StorageContext context, String dir) {
        return ChannelModelProvider.makeBasePath(context, dir).resolve("state.json");
    }

    static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.setLongSerializationPolicy(LongSerializationPolicy.STRING);
        builder.setDateFormat(DATE_FORMAT);
        builder.registerTypeAdapter(MetaKey.class, (Object)new JsonDeserializer<MetaKey>(){

            public MetaKey deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) throws JsonParseException {
                return MetaKey.fromString((String)json.getAsString());
            }
        });
        return builder.create();
    }

    public void closeWriteModel(ModifyContextImpl model) {
        BlobStore.Transaction blobTransaction = model.claimTransaction();
        CacheStore.Transaction cacheTransaction = model.claimCacheTransaction();
        Throwable throwable = null;
        Object var5_6 = null;
        try (Suppressed s = new Suppressed("Failed to close write model", RuntimeException::new);){
            if (blobTransaction != null) {
                s.run(blobTransaction::rollback);
            }
            if (cacheTransaction != null) {
                s.run(cacheTransaction::rollback);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void persistWriteModel(StorageContext context, ModifyContextImpl writeModel) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Profile.Handle h1 = Profile.start((Object)((Object)this), (String)"persistWriteModel");){
            AtomicReference<BlobStore.Transaction> t = new AtomicReference<BlobStore.Transaction>(writeModel.claimTransaction());
            AtomicReference<CacheStore.Transaction> ct = new AtomicReference<CacheStore.Transaction>(writeModel.claimCacheTransaction());
            Finally f = new Finally();
            f.add(() -> {
                BlobStore.Transaction v = (BlobStore.Transaction)t.get();
                if (v != null) {
                    v.rollback();
                }
            });
            f.add(() -> {
                CacheStore.Transaction v = (CacheStore.Transaction)ct.get();
                if (v != null) {
                    v.rollback();
                }
            });
            try {
                try {
                    block44: {
                        Path path = ChannelModelProvider.makeStatePath(context, this.dir);
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        if (t.get() != null) {
                            t.get().commit();
                            t.set(null);
                        }
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try (Profile.Handle h2 = Profile.start((Object)((Object)this), (String)"persistWriteModel#write");){
                            Throwable throwable3 = null;
                            Object var14_20 = null;
                            try {
                                ReplaceOnCloseOutputStream stream = new ReplaceOnCloseOutputStream(path);
                                try {
                                    try (ChannelWriter writer = new ChannelWriter((OutputStream)stream);){
                                        writer.write(writeModel);
                                        stream.commit();
                                    }
                                    if (stream == null) break block44;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    if (stream == null) throw throwable3;
                                    stream.close();
                                    throw throwable3;
                                }
                                stream.close();
                            }
                            catch (Throwable throwable5) {
                                if (throwable3 == null) {
                                    throwable3 = throwable5;
                                    throw throwable3;
                                }
                                if (throwable3 == throwable5) throw throwable3;
                                throwable3.addSuppressed(throwable5);
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                                throw throwable2;
                            }
                            if (throwable2 == throwable6) throw throwable2;
                            throwable2.addSuppressed(throwable6);
                            throw throwable2;
                        }
                    }
                    if (ct.get() == null) return;
                    ct.get().commit();
                    ct.set(null);
                    return;
                }
                catch (Exception e) {
                    logger.warn("Failed to persist model", (Throwable)e);
                    throw e;
                }
            }
            finally {
                Throwable throwable7 = null;
                Object var19_32 = null;
                try (Profile.Handle h2 = Profile.start((Object)((Object)this), (String)"persistWriteModel#finally");){
                    f.runAll();
                }
                catch (Throwable throwable8) {
                    if (throwable7 == null) {
                        throwable7 = throwable8;
                        throw throwable7;
                    }
                    if (throwable7 == throwable8) throw throwable7;
                    throwable7.addSuppressed(throwable8);
                    throw throwable7;
                }
            }
        }
        catch (Throwable throwable9) {
            if (throwable == null) {
                throwable = throwable9;
                throw throwable;
            }
            if (throwable == throwable9) throw throwable;
            throwable.addSuppressed(throwable9);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ModifyContextImpl loadWriteModel(StorageContext context) throws Exception {
        Path path = ChannelModelProvider.makeStatePath(context, this.dir);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
                try {
                    ModifyContextImpl modifyContextImpl;
                    block17: {
                        ChannelReader reader = new ChannelReader(stream, this.channelId, this.store, this.cacheStore);
                        try {
                            ModifyContextImpl model = reader.read();
                            if (model == null) {
                                throw new IllegalStateException("Unable to load channel model");
                            }
                            modifyContextImpl = model;
                            return modifyContextImpl;
                        }
                        finally {
                            if (reader == null) break block17;
                            reader.close();
                        }
                    }
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                    return modifyContextImpl;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    ((InputStream)stream).close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            ChannelModel model = new ChannelModel();
            model.setCreationTimestamp(new Date());
            return new ModifyContextImpl(this.channelId, this.store, this.cacheStore);
        }
    }
}

