/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.aspect;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.packagedrone.repo.ChannelAspectInformation;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.Severity;
import org.eclipse.packagedrone.repo.aspect.ChannelAspect;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectProcessor;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.repo.aspect.listener.PostAddContext;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.channel.AddingContext;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.PreAddContext;
import org.eclipse.packagedrone.repo.channel.ValidationMessage;
import org.eclipse.packagedrone.repo.channel.Veto;
import org.eclipse.packagedrone.repo.channel.VetoArtifactException;
import org.eclipse.packagedrone.repo.channel.apm.ChannelContextAccessor;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AddingContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AggregationContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.aspect.ArtifactType;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectableContext;
import org.eclipse.packagedrone.repo.channel.apm.aspect.Guard;
import org.eclipse.packagedrone.repo.channel.apm.aspect.PreAddContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.aspect.RegenerationTracker;
import org.eclipse.packagedrone.repo.channel.apm.aspect.VirtualizerContextImpl;
import org.eclipse.packagedrone.repo.channel.apm.internal.Activator;
import org.eclipse.packagedrone.repo.channel.provider.ChannelOperationContext;
import org.eclipse.packagedrone.repo.event.AddedEvent;
import org.eclipse.packagedrone.repo.event.RemovedEvent;
import org.eclipse.packagedrone.repo.generator.GenerationContext;
import org.eclipse.packagedrone.utils.Exceptions;
import org.eclipse.packagedrone.utils.Holder;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectContextImpl {
    private static final Logger logger = LoggerFactory.getLogger(AspectContextImpl.class);
    private final AspectableContext context;
    private final ChannelAspectProcessor processor;
    private final SortedMap<String, String> aspectStates;
    private final Guard aggregation;
    private final Guard postAdd;
    private final RegenerationTracker tracker;

    public AspectContextImpl(AspectableContext context, ChannelAspectProcessor processor) {
        this.context = context;
        this.processor = processor;
        this.aspectStates = context.getModifiableAspectStates();
        this.aggregation = new Guard(this::runAggregators);
        this.postAdd = new Guard(this::runPostAdd);
        this.tracker = new RegenerationTracker(this::runRegeneration);
    }

    protected ChannelOperationContext getOperationContext() {
        return ChannelContextAccessor.current().orElseThrow(() -> new IllegalStateException("No ChannelOperationContext present"));
    }

    public SortedMap<String, String> getAspectStates() {
        return this.aspectStates;
    }

    protected void runPostAdd() {
        logger.debug("Running post add");
        Profile.run((Object)this, (String)"runPostAdd", () -> this.processor.process(this.aspectStates.keySet(), ChannelAspect::getChannelListener, (aspect, listener) -> {
            logger.trace("\tRunning listener: {}", (Object)aspect.getId());
            PostAddContext ctx = new PostAddContext(){

                public Collection<ArtifactInformation> getChannelArtifacts() {
                    return AspectContextImpl.this.context.getArtifacts().values();
                }

                public Map<MetaKey, String> getChannelMetaData() {
                    return AspectContextImpl.this.context.getChannelProvidedMetaData();
                }

                public void deleteArtifacts(Set<String> artifactIds) {
                    AspectContextImpl.this.deleteArtifacts(artifactIds);
                }
            };
            try {
                listener.artifactAdded(ctx);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to run post add listener", e);
            }
        }));
    }

    protected void runAggregators() {
        logger.debug("Running aggregators");
        Profile.run((Object)this, (String)"runAggregators", () -> {
            HashMap<MetaKey, String> metaData = new HashMap<MetaKey, String>();
            CopyOnWriteArrayList<ValidationMessage> messages = new CopyOnWriteArrayList<ValidationMessage>();
            this.processor.process(this.aspectStates.keySet(), ChannelAspect::getChannelAggregator, (aspect, aggregator) -> {
                logger.trace("\tRunning aggregator: {}", (Object)aspect.getId());
                AggregationContextImpl ctx = new AggregationContextImpl(this.context, aspect.getId(), this.context.getChannelId(), messages::add);
                Map result = (Map)Exceptions.wrapException(() -> aggregator.aggregateMetaData(ctx));
                this.mergeNamespaceMetaData((ChannelAspect)aspect, result, (Map<MetaKey, String>)metaData);
            });
            this.context.setExtractedMetaData(metaData);
            this.context.setValidationMessages(messages);
        });
    }

    protected void runRegeneration(Set<String> artifactIds) {
        logger.debug("Running regeneration: {}", artifactIds);
        Profile.run((Object)this, (String)"runRegeneration", () -> {
            for (String artifactId : artifactIds) {
                this.regenerate(artifactId);
            }
        });
    }

    public void addAspects(Set<String> aspectIds) {
        logger.debug("Adding aspects: {}", aspectIds);
        this.aggregation.guarded(() -> this.tracker.run(() -> {
            this.removeVirtualized();
            HashSet<String> addedAspects = new HashSet<String>();
            for (ChannelAspectInformation aspect : this.processor.resolve((Collection)aspectIds)) {
                String versionString;
                String string = versionString = aspect.getVersion() != null ? aspect.getVersion().toString() : null;
                if (this.aspectStates.containsKey(aspect.getFactoryId())) continue;
                this.aspectStates.put(aspect.getFactoryId(), versionString);
                addedAspects.add(aspect.getFactoryId());
            }
            ArtifactInformation[] artifactInformationArray = this.context.getArtifacts().values().toArray(new ArtifactInformation[this.context.getArtifacts().size()]);
            int n = artifactInformationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArtifactInformation art = artifactInformationArray[n2];
                this.doStreamedRun(art.getId(), path -> {
                    ArtifactInformation updatedArt = this.extractFor(aspectIds, art, (Path)path);
                    this.virtualize(updatedArt, (Path)path, (Collection<String>)this.aspectStates.keySet());
                });
                ++n2;
            }
        }));
    }

    public void removeAspects(Set<String> aspectIds) {
        logger.debug("Removing aspects: {}", aspectIds);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Profile.Handle handle = Profile.start((Object)this, (String)"removeAspects");){
            this.aggregation.guarded(() -> this.tracker.run(() -> {
                this.removeVirtualized();
                for (String aspectId : aspectIds) {
                    this.aspectStates.remove(aspectId);
                }
                this.removeExtractedFor(aspectIds);
                this.virtualizeFor(this.aspectStates.keySet());
            }));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean filterValidation(Supplier<Collection<ValidationMessage>> input, Consumer<List<ValidationMessage>> output, Set<String> aspectIds) {
        Collection<ValidationMessage> list = input.get();
        CopyOnWriteArrayList<ValidationMessage> result = new CopyOnWriteArrayList<ValidationMessage>();
        boolean filtered = false;
        for (ValidationMessage msg : list) {
            if (aspectIds.contains(msg.getAspectId())) {
                filtered = true;
                continue;
            }
            result.add(msg);
        }
        output.accept(result);
        return filtered;
    }

    public void refreshAspects(Set<String> aspectIds) {
        Set<String> effectiveAspectIds = aspectIds == null || aspectIds.isEmpty() ? new HashSet<String>(this.aspectStates.keySet()) : aspectIds;
        this.aggregation.guarded(() -> this.tracker.run(() -> {
            this.removeVirtualized();
            for (ChannelAspectInformation aspect : this.processor.resolve((Collection)effectiveAspectIds)) {
                String versionString = aspect.getVersion() != null ? aspect.getVersion().toString() : null;
                this.aspectStates.put(aspect.getFactoryId(), versionString);
            }
            ArtifactInformation[] artifactInformationArray = this.context.getArtifacts().values().toArray(new ArtifactInformation[this.context.getArtifacts().size()]);
            int n = artifactInformationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArtifactInformation art = artifactInformationArray[n2];
                this.doStreamedRun(art.getId(), path -> {
                    ArtifactInformation updatedArt = this.extractFor(aspectIds, art, (Path)path);
                    this.virtualize(updatedArt, (Path)path, (Collection<String>)this.aspectStates.keySet());
                });
                ++n2;
            }
        }));
    }

    public ArtifactInformation createArtifact(String parentId, InputStream stream, String name, Map<MetaKey, String> providedMetaData) throws IOException {
        return this.aggregation.guarded(() -> this.postAdd.guarded(() -> this.tracker.run(() -> this.internalCreateArtifact(parentId, stream, name, providedMetaData, ArtifactType.STORED, null))));
    }

    public ArtifactInformation createGeneratorArtifact(String generatorId, InputStream stream, String name, Map<MetaKey, String> providedMetaData) throws IOException {
        return this.aggregation.guarded(() -> this.postAdd.guarded(() -> this.tracker.run(() -> {
            ArtifactInformation result = this.internalCreateArtifact(null, stream, name, providedMetaData, ArtifactType.GENERATOR, generatorId);
            this.generate(result);
            return result;
        })));
    }

    public void regenerate(String artifactId) {
        this.aggregation.guarded(() -> this.tracker.run(() -> {
            ArtifactInformation artifact = this.context.getArtifacts().get(artifactId);
            if (artifact == null) {
                throw new IllegalStateException(String.format("Unable to find artifact '%s'", artifactId));
            }
            if (!artifact.is("generator")) {
                throw new IllegalStateException(String.format("Artifact '%s' is not a generator", artifactId));
            }
            this.deleteGenerated(artifact);
            this.generate(artifact);
        }));
    }

    private void deleteGenerated(ArtifactInformation generator) {
        this.deleteChildren(generator, child -> child.is("generated"));
    }

    private void deleteChildren(ArtifactInformation generator, Predicate<ArtifactInformation> predicate) {
        HashSet<String> deletions = new HashSet<String>(1);
        for (String childId : generator.getChildIds()) {
            ArtifactInformation child = this.context.getArtifacts().get(childId);
            if (child == null || !predicate.test(child)) continue;
            deletions.add(childId);
        }
        this.deleteArtifacts(deletions);
    }

    private void generate(ArtifactInformation artifact) {
        this.doStreamedRun(artifact.getId(), file -> {
            String generatorId = artifact.getVirtualizerAspectId();
            VirtualizerContextImpl ctx = new VirtualizerContextImpl(generatorId, (Path)file, artifact, this.context, this::internalCreateArtifact, ArtifactType.GENERATED);
            Exceptions.wrapException(() -> Activator.getGeneratorProcessor().process(generatorId, (GenerationContext)ctx));
        });
    }

    private ArtifactInformation internalCreateArtifact(String parentId, IOConsumer<OutputStream> producer, String name, Map<MetaKey, String> providedMetaData, ArtifactType type, String virtualizerAspectId) throws IOException {
        Path tmp = Files.createTempFile("upload-", null, new FileAttribute[0]);
        return this.aggregation.guarded(() -> this.tracker.run(() -> {
            try {
                ArtifactInformation result;
                Throwable throwable = null;
                Object var9_10 = null;
                try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tmp, new OpenOption[0]));){
                    producer.accept((Object)out);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                Veto veto = this.checkVetoPreAdd(name, tmp, type.isExternal());
                if (veto != null) {
                    switch (veto.getPolicy()) {
                        case REJECT: {
                            return null;
                        }
                        case FAIL: {
                            this.failVeto(name, "pre-add", veto);
                            break;
                        }
                    }
                }
                AspectableContext.ArtifactAddition addition = this.context.preparePlainArtifact(parentId, name, providedMetaData, type.getFacetTypes(), virtualizerAspectId);
                ExtractionResult extraction = this.extractMetaData(new CoreArtifactInformation(addition), tmp, this.aspectStates.keySet());
                Veto veto2 = this.checkVetoAdding(name, tmp, type.isExternal(), providedMetaData, extraction.metadata, extraction.messages);
                if (veto2 != null) {
                    switch (veto2.getPolicy()) {
                        case REJECT: {
                            return null;
                        }
                        case FAIL: {
                            this.failVeto(name, "adding", veto2);
                            break;
                        }
                    }
                }
                Throwable throwable3 = null;
                Object var12_15 = null;
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(tmp, new OpenOption[0]));){
                    result = addition.create(in);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                        throw throwable3;
                    }
                    if (throwable3 == throwable4) throw throwable3;
                    throwable3.addSuppressed(throwable4);
                    throw throwable3;
                }
                result = this.context.setExtractedMetaData(result.getId(), extraction.metadata);
                result = this.context.setValidationMessages(result.getId(), extraction.messages);
                this.fireArtifactCreated(result);
                this.virtualize(result, tmp, this.aspectStates.keySet());
                ArtifactInformation artifactInformation = result;
                return artifactInformation;
            }
            finally {
                Files.deleteIfExists(tmp);
            }
        }));
    }

    private void failVeto(String artifactName, String phase, Veto veto) {
        throw new VetoArtifactException(artifactName, phase, veto.getPolicy(), veto.getMessage());
    }

    private ArtifactInformation internalCreateArtifact(String parentId, InputStream stream, String name, Map<MetaKey, String> providedMetaData, ArtifactType type, String virtualizerAspectId) throws IOException {
        return this.internalCreateArtifact(parentId, (IOConsumer<OutputStream>)((IOConsumer)out -> {
            long l = ByteStreams.copy((InputStream)stream, (OutputStream)out);
        }), name, providedMetaData, type, virtualizerAspectId);
    }

    private void fireArtifactCreated(ArtifactInformation artifact) {
        Profile.run((Object)this, (String)"fireArtifactCreated", () -> this.fireArtifactEvent(artifact, new AddedEvent(artifact.getId(), artifact.getMetaData())));
    }

    private void fireArtifactDeleted(ArtifactInformation artifact) {
        Profile.run((Object)this, (String)"fireArtifactDeleted", () -> this.fireArtifactEvent(artifact, new RemovedEvent(artifact.getId(), artifact.getMetaData())));
    }

    private void fireArtifactEvent(ArtifactInformation modifiedArtifact, Object event) {
        logger.debug("fireArtifactEvent - artifact: {}, event: {}", (Object)modifiedArtifact, event);
        for (ArtifactInformation artifact : this.context.getGeneratorArtifacts().values()) {
            logger.trace("\tTest artifact: {}", (Object)artifact);
            if (this.tracker.isMarked(artifact.getId())) continue;
            if (artifact.equals((Object)modifiedArtifact)) {
                logger.trace("\t\t-> is the modified one");
                continue;
            }
            if (!artifact.is("generator")) {
                logger.trace("\t\t-> is not a generator");
                continue;
            }
            Activator.getGeneratorProcessor().process(artifact.getVirtualizerAspectId(), generator -> {
                logger.trace("\t\t-> run 'shouldRegenerate'");
                if (generator.shouldRegenerate(event)) {
                    logger.trace("\t\t-> mark for regeneration");
                    this.tracker.mark(artifact.getId());
                }
            });
        }
    }

    private void virtualizeFor(Collection<String> aspects) {
        ArtifactInformation[] artifactInformationArray = this.context.getArtifacts().values().toArray(new ArtifactInformation[this.context.getArtifacts().size()]);
        int n = artifactInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactInformation artifact = artifactInformationArray[n2];
            this.doStreamedRun(artifact.getId(), tmp -> this.virtualize(artifact, (Path)tmp, aspects));
            ++n2;
        }
    }

    private void removeVirtualized() {
        HashSet<String> artifacts = new HashSet<String>();
        ArtifactInformation[] artifactInformationArray = this.context.getArtifacts().values().toArray(new ArtifactInformation[this.context.getArtifacts().size()]);
        int n = artifactInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactInformation artifact = artifactInformationArray[n2];
            if (artifact.is("virtual")) {
                artifacts.add(artifact.getId());
            }
            ++n2;
        }
        this.deleteArtifacts(artifacts);
    }

    private void virtualize(ArtifactInformation artifact, Path tmp, Collection<String> aspects) {
        logger.debug("Running virtualize - {} ({})", (Object)artifact, aspects);
        this.processor.process(aspects, ChannelAspect::getArtifactVirtualizer, (aspect, virtualizer) -> {
            VirtualizerContextImpl ctx = new VirtualizerContextImpl(aspect.getId(), tmp, artifact, this.context, this::internalCreateArtifact, ArtifactType.VIRTUAL);
            virtualizer.virtualize((Virtualizer.Context)ctx);
        });
    }

    private Veto checkVetoPreAdd(String name, Path file, boolean external) {
        PreAddContextImpl ctx = new PreAddContextImpl(name, file, external, this.context);
        this.getOperationContext().artifactPreAdd((PreAddContext)ctx);
        this.processor.process(this.aspectStates.keySet(), ChannelAspect::getChannelListener, listener -> Exceptions.wrapException(() -> listener.artifactPreAdd((PreAddContext)ctx)));
        return ctx.getVeto();
    }

    private Veto checkVetoAdding(String name, Path file, boolean external, Map<MetaKey, String> providedMetaData, Map<MetaKey, String> extractMetaData, List<ValidationMessage> validationMessages) {
        AddingContextImpl ctx = new AddingContextImpl(name, file, external, providedMetaData, extractMetaData, validationMessages, this.context);
        this.getOperationContext().artifactAdding((AddingContext)ctx);
        return ctx.getVeto();
    }

    public int deleteArtifacts(Set<String> artifactIds) {
        return this.aggregation.guarded(() -> this.tracker.run(() -> {
            int count = 0;
            for (String artifactId : artifactIds) {
                boolean result;
                boolean bl = result = this.internalDeleteArtifact(artifactId) != null;
                if (!result) continue;
                ++count;
            }
            return count;
        }));
    }

    private ArtifactInformation internalDeleteArtifact(String artifactId) {
        ArtifactInformation result = this.context.deletePlainArtifact(artifactId);
        if (result != null) {
            this.fireArtifactDeleted(result);
        }
        return result;
    }

    private void removeNamespaces(Set<String> aspectIds, Map<MetaKey, String> newMetaData) {
        Iterator<Map.Entry<MetaKey, String>> i = newMetaData.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<MetaKey, String> entry = i.next();
            if (!aspectIds.contains(entry.getKey().getNamespace())) continue;
            i.remove();
        }
    }

    private void removeExtractedFor(Set<String> aspectIds) {
        ArtifactInformation[] artifactInformationArray = this.context.getArtifacts().values().toArray(new ArtifactInformation[this.context.getArtifacts().size()]);
        int n = artifactInformationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactInformation art = artifactInformationArray[n2];
            HashMap<MetaKey, String> newMetaData = new HashMap<MetaKey, String>(art.getExtractedMetaData());
            this.removeNamespaces(aspectIds, newMetaData);
            this.context.setExtractedMetaData(art.getId(), newMetaData);
            LinkedList<ValidationMessage> newValidationMessages = new LinkedList<ValidationMessage>();
            this.filterValidation(() -> ((ArtifactInformation)art).getValidationMessages(), newValidationMessages::addAll, aspectIds);
            this.context.setValidationMessages(art.getId(), newValidationMessages);
            ++n2;
        }
    }

    private ArtifactInformation extractFor(Set<String> aspectIds, ArtifactInformation art, Path path) {
        ExtractionResult result = this.extractMetaData(new CoreArtifactInformation(art), path, aspectIds);
        Map<MetaKey, String> updatedMetaData = result.metadata;
        HashMap<MetaKey, String> newMetaData = new HashMap<MetaKey, String>(art.getExtractedMetaData());
        this.removeNamespaces(aspectIds, newMetaData);
        newMetaData.putAll(updatedMetaData);
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        this.filterValidation(() -> ((ArtifactInformation)art).getValidationMessages(), messages::addAll, aspectIds);
        messages.addAll(result.messages);
        this.context.setExtractedMetaData(art.getId(), newMetaData);
        return this.context.setValidationMessages(art.getId(), messages);
    }

    private ExtractionResult extractMetaData(CoreArtifactInformation coreInformation, Path path, Collection<String> aspectIds) {
        ExtractionResult result = new ExtractionResult();
        this.processor.process(aspectIds, ChannelAspect::getExtractor, (aspect, extractor) -> Exceptions.wrapException(() -> this.extractMetaData(coreInformation, extractionResult.metadata, extractionResult.messages, path, (ChannelAspect)aspect, (Extractor)extractor)));
        return result;
    }

    private void extractMetaData(final CoreArtifactInformation coreInformation, Map<MetaKey, String> result, final List<ValidationMessage> messages, final Path path, final ChannelAspect aspect, Extractor extractor) throws Exception {
        HashMap<String, String> md = new HashMap<String, String>();
        extractor.extractMetaData(new Extractor.Context(){

            public void validationMessage(Severity severity, String message) {
                messages.add(new ValidationMessage(aspect.getId(), severity, message, Collections.singleton(coreInformation.getId())));
            }

            public String getName() {
                return coreInformation.getName();
            }

            public Path getPath() {
                return path;
            }

            public Instant getCreationTimestamp() {
                return coreInformation.getCreationTimestamp();
            }
        }, md);
        this.mergeNamespaceMetaData(aspect, md, result);
    }

    private void mergeNamespaceMetaData(ChannelAspect aspect, Map<String, String> md, Map<MetaKey, String> result) {
        if (md == null) {
            return;
        }
        for (Map.Entry<String, String> entry : md.entrySet()) {
            result.put(new MetaKey(aspect.getId(), entry.getKey()), entry.getValue());
        }
    }

    private <T> T doStreamedCall(String artifactId, Function<Path, T> operation) {
        try {
            Holder result = new Holder();
            boolean streamed = this.context.stream(artifactId, (IOConsumer<InputStream>)((IOConsumer)stream -> {
                Path tmp = Files.createTempFile("blob-", null, new FileAttribute[0]);
                try {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(tmp, new OpenOption[0]));){
                        ByteStreams.copy((InputStream)stream, (OutputStream)os);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    holder.value = operation.apply(tmp);
                }
                finally {
                    Files.deleteIfExists(tmp);
                }
            }));
            if (!streamed) {
                throw new IllegalStateException("Unable to stream blob for: " + artifactId);
            }
            return (T)result.value;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to stream blob", e);
        }
    }

    private void doStreamedRun(String artifactId, Consumer<Path> consumer) {
        this.doStreamedCall(artifactId, path -> {
            consumer.accept((Path)path);
            return null;
        });
    }

    public void aggregate() {
        this.runAggregators();
    }

    @FunctionalInterface
    public static interface ArtifactCreator {
        public ArtifactInformation internalCreateArtifact(String var1, IOConsumer<OutputStream> var2, String var3, Map<MetaKey, String> var4, ArtifactType var5, String var6) throws IOException;
    }

    public static class CoreArtifactInformation {
        private final String id;
        private final String name;
        private final Instant creationTimestamp;

        public CoreArtifactInformation(String id, String name, Instant creationTimestamp) {
            this.id = id;
            this.name = name;
            this.creationTimestamp = creationTimestamp;
        }

        public CoreArtifactInformation(ArtifactInformation ai) {
            this(ai.getId(), ai.getName(), ai.getCreationInstant());
        }

        public CoreArtifactInformation(AspectableContext.ArtifactAddition addition) {
            this(addition.getId(), addition.getName(), addition.getCreationTimestamp());
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }
    }

    private class ExtractionResult {
        final Map<MetaKey, String> metadata = new HashMap<MetaKey, String>();
        final List<ValidationMessage> messages = new LinkedList<ValidationMessage>();

        private ExtractionResult() {
        }
    }
}

