/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.packagedrone.repo.importer.aether.Helper;

public class RepositoryContext {
    private final RepositorySystem system = Helper.newRepositorySystem();
    private final DefaultRepositorySystemSession session;
    private final List<RemoteRepository> repositories;

    public RepositoryContext(Path tmpDir, String repositoryUrl) {
        this(tmpDir, repositoryUrl, null);
    }

    public RepositoryContext(Path tmpDir, String repositoryUrl, Boolean allOptional) {
        this.session = Helper.newRepositorySystemSession(tmpDir, this.system);
        if (allOptional != null) {
            LinkedList<Object> selectors = new LinkedList<Object>();
            selectors.add(new ScopeDependencySelector(new String[]{"test", "provided"}));
            if (!allOptional.booleanValue()) {
                selectors.add(new OptionalDependencySelector());
            }
            selectors.add(new ExclusionDependencySelector());
            this.session.setDependencySelector((DependencySelector)new AndDependencySelector(selectors));
        }
        this.repositories = repositoryUrl == null || repositoryUrl.isEmpty() ? Collections.singletonList(Helper.newCentralRepository()) : Collections.singletonList(Helper.newRemoteRepository("drone.aether.import", repositoryUrl));
    }

    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public RepositorySystem getSystem() {
        return this.system;
    }
}

