/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.dispatcher.DispatcherHttpContext;
import org.eclipse.packagedrone.web.dispatcher.internal.ResourceProvider;
import org.eclipse.packagedrone.web.dispatcher.internal.TagDirTracker;
import org.eclipse.packagedrone.web.dispatcher.internal.TagLibTracker;
import org.ops4j.pax.web.service.WebContainerContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextImpl
implements WebContainerContext,
DispatcherHttpContext {
    private static final Logger logger = LoggerFactory.getLogger(ServletContextImpl.class);
    private final List<ResourceProvider> sources = new LinkedList<ResourceProvider>();
    private final Bundle bundle;

    public ServletContextImpl(BundleContext context) {
        this.bundle = context.getBundle();
        this.sources.add(new TagDirTracker(context));
        this.sources.add(new TagLibTracker(context, "/WEB-INF/"));
    }

    public String toString() {
        return String.format("[HttpContext for: %s / %s]", this.bundle.getBundleId(), this.bundle.getSymbolicName());
    }

    public String getMimeType(String name) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    public URL getResource(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace("Getting resource: {}", (Object)name);
        }
        URL result = this.internalGetResource(name);
        if (logger.isTraceEnabled()) {
            logger.trace("Getting resource: {} -> {}", (Object)name, (Object)result);
        }
        return result;
    }

    public Set<String> getResourcePaths(String path) {
        if (logger.isTraceEnabled()) {
            logger.trace("Getting resource paths: {}", (Object)path);
        }
        HashSet<String> result = new HashSet<String>();
        this.internalGetResourcePaths(path, result);
        if (logger.isTraceEnabled()) {
            logger.trace("Getting resource paths: {} -> {}", (Object)path, result);
        }
        return result.isEmpty() ? null : result;
    }

    protected URL internalGetResource(String name) {
        for (ResourceProvider provider : this.sources) {
            URL result = provider.getResource(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected void internalGetResourcePaths(String path, Set<String> result) {
        for (ResourceProvider provider : this.sources) {
            Set<String> providerResult = provider.getPaths(path);
            if (providerResult == null) continue;
            result.addAll(providerResult);
        }
    }

    @Override
    public void dispose() {
        for (ResourceProvider provider : this.sources) {
            provider.dispose();
        }
    }
}

