/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.eclipse.packagedrone.web.RequestHandler;

public class JaxRsResponseHandler
implements RequestHandler {
    private final Response response;

    public JaxRsResponseHandler(Response response) {
        this.response = Objects.requireNonNull(response);
    }

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        MediaType mediaType = this.response.getMediaType();
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
        if (this.response.getLength() > 0) {
            response.setContentLength(this.response.getLength());
        }
        response.setStatus(this.response.getStatus());
        for (Map.Entry entry : this.response.getStringHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                response.addHeader((String)entry.getKey(), value);
            }
        }
        if (this.response.getCookies() != null) {
            for (Map.Entry entry : this.response.getCookies().entrySet()) {
                response.addCookie(JaxRsResponseHandler.mapCookie(entry));
            }
        }
        response.getWriter().append(this.response.getEntity().toString());
    }

    private static Cookie mapCookie(Map.Entry<String, NewCookie> entry) {
        String name = entry.getKey();
        NewCookie nc = entry.getValue();
        Cookie cookie = new Cookie(name, nc.getValue());
        cookie.setComment(nc.getComment());
        cookie.setDomain(nc.getDomain());
        cookie.setHttpOnly(nc.isHttpOnly());
        cookie.setMaxAge(nc.getMaxAge());
        cookie.setPath(nc.getPath());
        cookie.setSecure(nc.isSecure());
        cookie.setVersion(nc.getVersion());
        return cookie;
    }

    @Override
    public void close() {
        this.response.close();
    }
}

