/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.extender;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.packagedrone.web.extender.WebExtender;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WebExtenderProcessor {
    private final BundleContext context;
    private final ServiceTracker<WebExtender, WebExtender> tracker;
    private final ServiceTrackerCustomizer<WebExtender, WebExtender> customizer = new ServiceTrackerCustomizer<WebExtender, WebExtender>(){

        public void removedService(ServiceReference<WebExtender> reference, WebExtender service) {
            WebExtenderProcessor.this.removeService(service);
            WebExtenderProcessor.this.context.ungetService(reference);
        }

        public void modifiedService(ServiceReference<WebExtender> reference, WebExtender service) {
        }

        public WebExtender addingService(ServiceReference<WebExtender> reference) {
            WebExtender service = (WebExtender)WebExtenderProcessor.this.context.getService(reference);
            WebExtenderProcessor.this.addService(service);
            return service;
        }
    };
    private final Set<WebExtender> extenders = new CopyOnWriteArraySet<WebExtender>();

    public WebExtenderProcessor(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, WebExtender.class, this.customizer);
        this.tracker.open();
    }

    protected void addService(WebExtender service) {
        this.extenders.add(service);
    }

    protected void removeService(WebExtender service) {
        this.extenders.remove(service);
    }

    public void process(Consumer consumer) throws IOException {
        for (WebExtender extender : this.extenders) {
            consumer.process(extender);
        }
    }

    public void dispose() {
        this.tracker.close();
    }

    @FunctionalInterface
    public static interface Consumer {
        public void process(WebExtender var1) throws IOException;
    }
}

