/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.cleanup;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.cleanup.Action;
import org.eclipse.packagedrone.repo.cleanup.Aggregator;
import org.eclipse.packagedrone.repo.cleanup.ResultEntry;
import org.eclipse.packagedrone.repo.cleanup.ResultKey;
import org.eclipse.packagedrone.repo.cleanup.Sorter;

public class Cleaner {
    private final Supplier<Collection<? extends ArtifactInformation>> artifactSupplier;
    private Aggregator aggregator;
    private Sorter sorter;
    private boolean rootOnly = true;
    private boolean requireAll = false;
    private int numberOfEntries = Integer.MAX_VALUE;

    public Cleaner(Supplier<Collection<? extends ArtifactInformation>> artifactSupplier) {
        this.artifactSupplier = artifactSupplier;
    }

    public void setAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public void setSorter(Sorter sorter) {
        this.sorter = sorter;
    }

    public Sorter getSorter() {
        return this.sorter;
    }

    public void setRootOnly(boolean rootOnly) {
        this.rootOnly = rootOnly;
    }

    public boolean isRootOnly() {
        return this.rootOnly;
    }

    public void setRequireAll(boolean requireAll) {
        this.requireAll = requireAll;
    }

    public boolean isRequireAll() {
        return this.requireAll;
    }

    public void setNumberOfEntries(int numberOfEntries) {
        this.numberOfEntries = numberOfEntries < 0 ? 0 : numberOfEntries;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public Result compute() {
        if (this.aggregator == null) {
            throw new IllegalStateException("There is no aggregator set");
        }
        if (this.sorter == null) {
            throw new IllegalStateException("There is no sorter set");
        }
        Map<List<String>, LinkedList<ArtifactInformation>> aggregation = this.aggregate();
        SortedMap<ResultKey, List<ResultEntry>> result = this.process(aggregation);
        return new Result(result);
    }

    private Map<List<String>, LinkedList<ArtifactInformation>> aggregate() {
        HashMap<List<String>, LinkedList<ArtifactInformation>> result = new HashMap<List<String>, LinkedList<ArtifactInformation>>();
        for (ArtifactInformation artifactInformation : this.artifactSupplier.get()) {
            List<String> key;
            if (!artifactInformation.is("stored") || this.rootOnly && artifactInformation.getParentId() != null || (key = this.aggregator.makeKey(artifactInformation.getMetaData(), this.requireAll)) == null) continue;
            LinkedList<ArtifactInformation> list = (LinkedList<ArtifactInformation>)result.get(key);
            if (list == null) {
                list = new LinkedList<ArtifactInformation>();
                result.put(key, list);
            }
            list.add(artifactInformation);
        }
        Comparator<ArtifactInformation> comparator = this.sorter.makeComparator();
        for (LinkedList list : result.values()) {
            Collections.sort(list, comparator);
        }
        return result;
    }

    private SortedMap<ResultKey, List<ResultEntry>> process(Map<List<String>, LinkedList<ArtifactInformation>> aggregation) {
        TreeMap<ResultKey, List<ResultEntry>> result = new TreeMap<ResultKey, List<ResultEntry>>();
        for (Map.Entry<List<String>, LinkedList<ArtifactInformation>> entry : aggregation.entrySet()) {
            ResultKey key = new ResultKey(entry.getKey());
            LinkedList<ResultEntry> value = (LinkedList<ResultEntry>)result.get(key);
            if (value == null) {
                value = new LinkedList<ResultEntry>();
                result.put(key, value);
            }
            int cutOff = entry.getValue().size() - this.numberOfEntries;
            int i = 0;
            for (ArtifactInformation art : entry.getValue()) {
                Action action = i < cutOff ? Action.DELETE : Action.KEEP;
                value.add(new ResultEntry(art, action));
                ++i;
            }
        }
        return result;
    }

    public static final class Result {
        private final SortedMap<ResultKey, List<ResultEntry>> entries;

        public Result(SortedMap<ResultKey, List<ResultEntry>> entries) {
            this.entries = entries;
        }

        public Stream<String> deletedSetStream() {
            return this.entries.values().stream().flatMap(list -> list.stream()).filter(entry -> entry.getAction() == Action.DELETE).map(entry -> entry.getArtifact().getId());
        }

        public SortedMap<ResultKey, List<ResultEntry>> getEntries() {
            return this.entries;
        }
    }
}

