/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common.eclipse;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiExtractor;
import org.eclipse.packagedrone.repo.aspect.virtual.Virtualizer;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenSourceBundleVirtualizer
implements Virtualizer {
    private static final Logger logger = LoggerFactory.getLogger(MavenSourceBundleVirtualizer.class);

    public void virtualize(Virtualizer.Context context) {
        ArtifactInformation ai = context.getArtifactInformation();
        if (ai.getParentId() == null) {
            logger.debug("don't create - parent id is null");
            return;
        }
        if (!ai.getName().endsWith("-sources.jar")) {
            logger.debug("don't create - name does not match");
            return;
        }
        if (this.isSourceBundle(ai)) {
            return;
        }
        ArtifactInformation parent = this.findParent(context);
        if (parent == null) {
            return;
        }
        BundleInformation bi = this.findBundleInformation(parent);
        if (bi == null) {
            logger.debug("don't create - parent has no bundle information");
            return;
        }
        try {
            this.createSourceBundle(context, bi);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create virtual source bundle", e);
        }
    }

    private boolean isSourceBundle(ArtifactInformation parent) {
        String full = (String)parent.getMetaData().get(OsgiExtractor.KEY_FULL_MANIFEST);
        if (full == null) {
            return false;
        }
        try {
            Manifest mf = new Manifest(new ByteArrayInputStream(full.getBytes(StandardCharsets.UTF_8)));
            String esb = mf.getMainAttributes().getValue("Eclipse-SourceBundle");
            return esb != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected void createSourceBundle(Virtualizer.Context context, BundleInformation bi) throws Exception {
        HashMap providedMetaData = new HashMap();
        String name = String.format("%s.source_%s.jar", bi.getId(), bi.getVersion());
        context.createVirtualArtifact(name, out -> this.createSourceBundle((OutputStream)out, context, bi), providedMetaData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createSourceBundle(OutputStream out, Virtualizer.Context context, BundleInformation bi) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(Files.newInputStream(context.getFile(), new OpenOption[0])));
            try {
                try (ZipOutputStream zos = new ZipOutputStream(out);){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                        zos.putNextEntry(entry);
                        ByteStreams.copy((InputStream)zis, (OutputStream)zos);
                    }
                    entry = new ZipEntry("META-INF/MANIFEST.MF");
                    zos.putNextEntry(entry);
                    Manifest mf = new Manifest();
                    this.fillManifest(mf, bi);
                    mf.write(zos);
                    if (bi.getLocalization() != null && !bi.getLocalization().isEmpty()) {
                        for (Map.Entry le : bi.getLocalization().entrySet()) {
                            String locale = (String)le.getKey();
                            String suffix = locale != null && !locale.isEmpty() ? "_" + locale : "";
                            entry = new ZipEntry(bi.getLocalization() + suffix);
                            zos.putNextEntry(entry);
                            ((Properties)le.getValue()).store(zos, null);
                        }
                    }
                }
                if (zis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (zis == null) throw throwable;
                zis.close();
                throw throwable;
            }
            zis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void fillManifest(Manifest mf, BundleInformation bi) {
        Attributes attr = mf.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.putValue("Bundle-SymbolicName", String.valueOf(bi.getId()) + ".source");
        attr.putValue("Bundle-Version", "" + bi.getVersion());
        attr.putValue("Bundle-ManifestVersion", "2");
        attr.putValue("Bundle-Vendor", bi.getVendor());
        attr.putValue("Bundle-Name", String.format("Source bundle for '%s'", bi.getId()));
        attr.putValue("Created-By", VersionInformation.VERSIONED_PRODUCT);
        attr.putValue("Eclipse-SourceBundle", this.makeSourceString(bi));
        if (bi.getBundleLocalization() != null) {
            attr.putValue("Bundle-Localization", bi.getBundleLocalization());
        }
    }

    private String makeSourceString(BundleInformation bi) {
        StringBuilder sb = new StringBuilder();
        sb.append(bi.getId());
        sb.append(';');
        sb.append("version=\"").append(bi.getVersion()).append("\"");
        sb.append(';');
        sb.append("roots:=");
        sb.append("\".\"");
        return sb.toString();
    }

    private ArtifactInformation findParent(Virtualizer.Context context) {
        return context.getOtherArtifactInformation(context.getArtifactInformation().getParentId());
    }

    private BundleInformation findBundleInformation(ArtifactInformation parent) {
        String biString = (String)parent.getMetaData().get(BundleInformation.META_KEY);
        return BundleInformation.fromJson((String)biString);
    }
}

