/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.internal.security;

import com.eclipsesource.jaxrs.provider.security.AuthenticationHandler;
import com.eclipsesource.jaxrs.provider.security.AuthorizationHandler;
import java.security.Principal;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import org.eclipse.packagedrone.sec.service.SecurityService;
import org.eclipse.packagedrone.sec.service.common.AccessTokenPrincipal;

public class SecurityHandler
implements AuthenticationHandler,
AuthorizationHandler {
    private SecurityService securityService;

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public boolean isUserInRole(Principal user, String role) {
        if (user instanceof AccessTokenPrincipal) {
            return ((AccessTokenPrincipal)user).getRoles().contains(role);
        }
        return false;
    }

    public Principal authenticate(ContainerRequestContext requestContext) {
        String[] toks;
        String auth = requestContext.getHeaderString("Authorization");
        if (auth != null && !auth.isEmpty() && (toks = auth.split("\\s+", 2)).length == 2 && toks[0].equals("token")) {
            String token = toks[1];
            return this.securityService.accessByToken(token).orElse(null);
        }
        List tokens = (List)requestContext.getUriInfo().getQueryParameters().get((Object)"access_token");
        if (tokens != null && !tokens.isEmpty()) {
            return this.securityService.accessByToken((String)tokens.get(0)).orElse(null);
        }
        return null;
    }

    public String getAuthenticationScheme() {
        return null;
    }
}

