/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Node;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class JDTJavaCompiler
implements JavaCompiler {
    private final Map settings = new HashMap();
    private JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private Logger log;
    private String javaFileName;
    private static boolean USE_INTROSPECTION_TO_INVOKE_GET_PROBLEM = false;
    private static Method GET_PROBLEM_METH = null;

    @Override
    public void init(JspCompilationContext ctxt, ErrorDispatcher errDispatcher, boolean suppressLogging) {
        this.errDispatcher = errDispatcher;
        this.ctxt = ctxt;
        this.log = Logger.getLogger(JDTJavaCompiler.class.getName());
        if (suppressLogging) {
            this.log.setLevel(Level.OFF);
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void setExtdirs(String exts) {
    }

    @Override
    public void setClassPath(List<File> cpath) {
    }

    @Override
    public long getClassLastModified() {
        File classFile = new File(this.ctxt.getClassFileName());
        return classFile.lastModified();
    }

    @Override
    public Writer getJavaWriter(String javaFileName, String javaEncoding) throws JasperException {
        this.javaFileName = javaFileName;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
        }
        catch (IOException ex) {
            this.errDispatcher.jspError("jsp.error.unableToCreateOutputWriter", javaFileName, ex);
        }
        return writer;
    }

    @Override
    public void setDebug(boolean debug) {
        this.settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        if (debug) {
            this.settings.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        }
    }

    @Override
    public void setSourceVM(String sourceVM) {
        if (sourceVM.equals("1.1")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.1");
        } else if (sourceVM.equals("1.2")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.2");
        } else if (sourceVM.equals("1.3")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.3");
        } else if (sourceVM.equals("1.4")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.4");
        } else if (sourceVM.equals("1.5")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
        } else if (sourceVM.equals("1.6")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.6");
        } else if (sourceVM.equals("1.7")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.7");
        } else if (sourceVM.equals("1.8")) {
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.8");
        } else {
            this.log.warning("Unknown source VM " + sourceVM + " ignored.");
            this.settings.put("org.eclipse.jdt.core.compiler.source", "1.5");
        }
    }

    @Override
    public void setTargetVM(String targetVM) {
        if (targetVM.equals("1.1")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
        } else if (targetVM.equals("1.2")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
        } else if (targetVM.equals("1.3")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
        } else if (targetVM.equals("1.4")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
        } else if (targetVM.equals("1.5")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        } else if (targetVM.equals("1.6")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
        } else if (targetVM.equals("1.7")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
        } else if (targetVM.equals("1.8")) {
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        } else {
            this.log.warning("Unknown target VM " + targetVM + " ignored.");
            this.settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        }
    }

    @Override
    public void saveClassFile(String className, String classFileName) {
    }

    @Override
    public void doJavaFile(boolean keep) {
        if (!keep) {
            File javaFile = new File(this.javaFileName);
            javaFile.delete();
        }
    }

    @Override
    public JavacErrorDetail[] compile(final String targetClassName, final Node.Nodes pageNodes) throws JasperException {
        final String sourceFile = this.ctxt.getServletJavaFileName();
        final String outputDir = this.ctxt.getOptions().getScratchDir().getAbsolutePath();
        this.ctxt.getServletPackageName();
        final ClassLoader classLoader = this.ctxt.getJspLoader();
        String[] fileNames = new String[]{sourceFile};
        String[] classNames = new String[]{targetClassName};
        final ArrayList problemList = new ArrayList();
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                String result = "";
                String sep = "";
                int i = 0;
                while (i < compoundTypeName.length) {
                    result = String.valueOf(result) + sep;
                    result = String.valueOf(result) + new String(compoundTypeName[i]);
                    sep = ".";
                    ++i;
                }
                return this.findType(result);
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                String result = "";
                String sep = "";
                int i = 0;
                while (i < packageName.length) {
                    result = String.valueOf(result) + sep;
                    result = String.valueOf(result) + new String(packageName[i]);
                    sep = ".";
                    ++i;
                }
                result = String.valueOf(result) + sep;
                result = String.valueOf(result) + new String(typeName);
                return this.findType(result);
            }

            /*
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private NameEnvironmentAnswer findType(String className) {
                InputStream is;
                block21: {
                    int count;
                    block20: {
                        is = null;
                        if (!className.equals(targetClassName)) break block20;
                        class CompilationUnit
                        implements ICompilationUnit {
                            String className;
                            String sourceFile;

                            CompilationUnit(String sourceFile, String className) {
                                this.className = className;
                                this.sourceFile = sourceFile;
                            }

                            public char[] getFileName() {
                                return this.className.toCharArray();
                            }

                            public char[] getContents() {
                                char[] result;
                                block16: {
                                    result = null;
                                    Reader reader = null;
                                    try {
                                        try {
                                            InputStreamReader isReader = new InputStreamReader((InputStream)new FileInputStream(this.sourceFile), JDTJavaCompiler.this.ctxt.getOptions().getJavaEncoding());
                                            reader = new BufferedReader(isReader);
                                            if (reader != null) {
                                                int count;
                                                char[] chars = new char[8192];
                                                StringBuilder buf = new StringBuilder();
                                                while ((count = reader.read(chars, 0, chars.length)) > 0) {
                                                    buf.append(chars, 0, count);
                                                }
                                                result = new char[buf.length()];
                                                buf.getChars(0, result.length, result, 0);
                                            }
                                        }
                                        catch (IOException e) {
                                            JDTJavaCompiler.this.log.log(Level.SEVERE, "Compilation error", e);
                                            if (reader != null) {
                                                try {
                                                    reader.close();
                                                }
                                                catch (IOException iOException) {}
                                            }
                                            break block16;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        throw throwable;
                                    }
                                    if (reader != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                                return result;
                            }

                            public char[] getMainTypeName() {
                                int dot = this.className.lastIndexOf(46);
                                if (dot > 0) {
                                    return this.className.substring(dot + 1).toCharArray();
                                }
                                return this.className.toCharArray();
                            }

                            public char[][] getPackageName() {
                                StringTokenizer izer = new StringTokenizer(this.className, ".");
                                char[][] result = new char[izer.countTokens() - 1][];
                                int i = 0;
                                while (i < result.length) {
                                    String tok = izer.nextToken();
                                    result[i] = tok.toCharArray();
                                    ++i;
                                }
                                return result;
                            }

                            public boolean ignoreOptionalProblems() {
                                return true;
                            }
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(sourceFile, className);
                        NameEnvironmentAnswer nameEnvironmentAnswer2 = new NameEnvironmentAnswer((ICompilationUnit)compilationUnit, null);
                        if (is == null) return nameEnvironmentAnswer2;
                        try {
                            is.close();
                            return nameEnvironmentAnswer2;
                        }
                        catch (IOException iOException) {}
                        return nameEnvironmentAnswer2;
                    }
                    String resourceName = String.valueOf(className.replace('.', '/')) + ".class";
                    is = classLoader.getResourceAsStream(resourceName);
                    if (is == null) break block21;
                    byte[] buf = new byte[8192];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                    while ((count = is.read(buf, 0, buf.length)) > 0) {
                        baos.write(buf, 0, count);
                    }
                    baos.flush();
                    byte[] classBytes = baos.toByteArray();
                    char[] fileName = className.toCharArray();
                    ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                    NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    if (is == null) return nameEnvironmentAnswer;
                    try {
                        is.close();
                        return nameEnvironmentAnswer;
                    }
                    catch (IOException iOException) {}
                    return nameEnvironmentAnswer;
                    catch (IOException exc) {
                        JDTJavaCompiler.this.log.log(Level.SEVERE, "Compilation error", exc);
                        if (is == null) return null;
                        try {
                            is.close();
                            return null;
                        }
                        catch (IOException iOException) {}
                        return null;
                    }
                    catch (ClassFormatException exc2) {
                        JDTJavaCompiler.this.log.log(Level.SEVERE, "Compilation error", exc2);
                        if (is == null) return null;
                        {
                            catch (Throwable throwable) {
                                if (is == null) throw throwable;
                                try {
                                    is.close();
                                    throw throwable;
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                        }
                        try {
                            is.close();
                            return null;
                        }
                        catch (IOException iOException) {}
                        return null;
                    }
                }
                if (is == null) return null;
                try {
                    is.close();
                    return null;
                }
                catch (IOException iOException) {}
                return null;
            }

            private boolean isPackage(String result) {
                if (result.equals(targetClassName)) {
                    return false;
                }
                String resourceName = String.valueOf(result.replace('.', '/')) + ".class";
                InputStream is = classLoader.getResourceAsStream(resourceName);
                return is == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String str;
                String result = "";
                String sep = "";
                if (parentPackageName != null) {
                    int i = 0;
                    while (i < parentPackageName.length) {
                        result = String.valueOf(result) + sep;
                        String str2 = new String(parentPackageName[i]);
                        result = String.valueOf(result) + str2;
                        sep = ".";
                        ++i;
                    }
                }
                if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                    return false;
                }
                result = String.valueOf(result) + sep;
                result = String.valueOf(result) + str;
                return this.isPackage(result);
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        if (this.ctxt.getOptions().getJavaEncoding() != null) {
            this.settings.put("org.eclipse.jdt.core.encoding", this.ctxt.getOptions().getJavaEncoding());
        }
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                try {
                    int i;
                    if (result.hasProblems()) {
                        IProblem[] problems = JDTJavaCompiler.safeGetProblems(result);
                        i = 0;
                        while (i < problems.length) {
                            IProblem problem = problems[i];
                            if (problem.isError()) {
                                String name = new String(problems[i].getOriginatingFileName());
                                try {
                                    problemList.add(ErrorDispatcher.createJavacError(name, pageNodes, new StringBuilder(problem.getMessage()), problem.getSourceLineNumber()));
                                }
                                catch (JasperException e) {
                                    JDTJavaCompiler.this.log.log(Level.SEVERE, "Error visiting node", (Throwable)((Object)e));
                                }
                            }
                            ++i;
                        }
                    }
                    if (problemList.isEmpty()) {
                        ClassFile[] classFiles = result.getClassFiles();
                        i = 0;
                        while (i < classFiles.length) {
                            ClassFile classFile = classFiles[i];
                            char[][] compoundName = classFile.getCompoundName();
                            String className = "";
                            String sep = "";
                            int j = 0;
                            while (j < compoundName.length) {
                                className = String.valueOf(className) + sep;
                                className = String.valueOf(className) + new String(compoundName[j]);
                                sep = ".";
                                ++j;
                            }
                            byte[] bytes = classFile.getBytes();
                            String outFile = String.valueOf(outputDir) + "/" + className.replace('.', '/') + ".class";
                            FileOutputStream fout = new FileOutputStream(outFile);
                            BufferedOutputStream bos = new BufferedOutputStream(fout);
                            bos.write(bytes);
                            bos.close();
                            ++i;
                        }
                    }
                }
                catch (IOException exc) {
                    JDTJavaCompiler.this.log.log(Level.SEVERE, "Compilation error", exc);
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[classNames.length];
        int i = 0;
        while (i < compilationUnits.length) {
            compilationUnits[i] = new CompilationUnit(fileNames[i], classNames[i]);
            ++i;
        }
        Compiler compiler = new Compiler(env, policy, this.settings, requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        if (problemList.isEmpty()) {
            return null;
        }
        return problemList.toArray(new JavacErrorDetail[0]);
    }

    private static final IProblem[] safeGetProblems(CompilationResult result) {
        if (!USE_INTROSPECTION_TO_INVOKE_GET_PROBLEM) {
            try {
                return result.getProblems();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                USE_INTROSPECTION_TO_INVOKE_GET_PROBLEM = true;
            }
        }
        try {
            if (GET_PROBLEM_METH == null) {
                GET_PROBLEM_METH = result.getClass().getDeclaredMethod("getProblems", new Class[0]);
            }
            return (IProblem[])GET_PROBLEM_METH.invoke((Object)result, null);
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

