/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.rpm.yum;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.eclipse.packagedrone.repo.adapter.rpm.RpmInformation;
import org.eclipse.packagedrone.repo.aspect.common.spool.OutputSpooler;
import org.eclipse.packagedrone.repo.aspect.common.spool.SpoolOutTarget;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.signing.SigningService;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.packagedrone.utils.rpm.RpmVersion;
import org.eclipse.packagedrone.utils.rpm.deps.RpmDependencyFlags;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RepositoryCreator {
    private static final String MD_NAME = "SHA-256";
    private static final String MD_TAG = "sha256";
    private final XmlHelper xml = new XmlHelper();
    private final OutputSpooler primaryStreamBuilder;
    private final OutputSpooler filelistsStreamBuilder;
    private final OutputSpooler otherStreamBuilder;
    private final OutputSpooler mdStreamBuilder;
    private final List<Pattern> primaryFiles;
    private final List<Pattern> primaryDirs;
    private final String primaryUniqueName;
    private final String filelistsUniqueName;
    private final String otherUniqueName;

    public RepositoryCreator(SpoolOutTarget target, SigningService signing) {
        String dirFilter = System.getProperty("drone.rpm.yum.primaryDirs", "bin/,^/etc/");
        String fileFilter = System.getProperty("drone.rpm.yum.primaryFiles", dirFilter);
        this.primaryFiles = Arrays.stream(fileFilter.split(",")).map(re -> Pattern.compile(re)).collect(Collectors.toList());
        this.primaryDirs = Arrays.stream(dirFilter.split(",")).map(re -> Pattern.compile(re)).collect(Collectors.toList());
        this.primaryUniqueName = UUID.randomUUID().toString().replace("-", "");
        this.filelistsUniqueName = UUID.randomUUID().toString().replace("-", "");
        this.otherUniqueName = UUID.randomUUID().toString().replace("-", "");
        this.primaryStreamBuilder = new OutputSpooler(target);
        this.primaryStreamBuilder.addDigest(MD_NAME);
        this.primaryStreamBuilder.addOutput(String.format("repodata/%s-primary.xml", this.primaryUniqueName), "application/xml");
        this.primaryStreamBuilder.addOutput(String.format("repodata/%s-primary.xml.gz", this.primaryUniqueName), "application/x-gzip", output -> new GZIPOutputStream((OutputStream)output));
        this.filelistsStreamBuilder = new OutputSpooler(target);
        this.filelistsStreamBuilder.addDigest(MD_NAME);
        this.filelistsStreamBuilder.addOutput(String.format("repodata/%s-filelists.xml", this.filelistsUniqueName), "application/xml");
        this.filelistsStreamBuilder.addOutput(String.format("repodata/%s-filelists.xml.gz", this.filelistsUniqueName), "application/x-gzip", output -> new GZIPOutputStream((OutputStream)output));
        this.otherStreamBuilder = new OutputSpooler(target);
        this.otherStreamBuilder.addDigest(MD_NAME);
        this.otherStreamBuilder.addOutput(String.format("repodata/%s-other.xml", this.otherUniqueName), "application/xml");
        this.otherStreamBuilder.addOutput(String.format("repodata/%s-other.xml.gz", this.otherUniqueName), "application/x-gzip", output -> new GZIPOutputStream((OutputStream)output));
        this.mdStreamBuilder = new OutputSpooler(target);
        this.mdStreamBuilder.addOutput("repodata/repomd.xml", "application/xml");
        if (signing != null) {
            this.mdStreamBuilder.addOutput("repodata/repomd.xml.asc", "text/plain", output -> signing.signingStream(output, false));
        }
    }

    public boolean matches(String pathName, List<Pattern> filterList) {
        for (Pattern p : filterList) {
            if (!p.matcher(pathName).find()) continue;
            return true;
        }
        return false;
    }

    public void process(IOConsumer<Context> consumer) throws IOException {
        long now = System.currentTimeMillis();
        this.primaryStreamBuilder.open(primaryStream -> this.filelistsStreamBuilder.open(filelistsStream -> this.otherStreamBuilder.open(otherStream -> {
            ContextImpl ctx = this.makeContext((OutputStream)primaryStream, (OutputStream)filelistsStream, (OutputStream)otherStream);
            consumer.accept((Object)ctx);
            ctx.close();
        })));
        this.mdStreamBuilder.open(stream -> this.writeRepoMd((OutputStream)stream, now));
    }

    private ContextImpl makeContext(OutputStream primaryStream, OutputStream filelistsStream, OutputStream otherStream) {
        return new ContextImpl(primaryStream, filelistsStream, otherStream, this.xml);
    }

    private void writeRepoMd(OutputStream stream, long now) throws IOException {
        Document doc = this.xml.createNs();
        Element root = doc.createElementNS("http://linux.duke.edu/metadata/repo", "repomd");
        doc.appendChild(root);
        root.setAttribute("revision", Long.toString(now / 1000L));
        this.addDataFile(root, this.primaryStreamBuilder, this.primaryUniqueName, "primary", now);
        this.addDataFile(root, this.filelistsStreamBuilder, this.filelistsUniqueName, "filelists", now);
        this.addDataFile(root, this.otherStreamBuilder, this.otherUniqueName, "other", now);
        try {
            this.xml.write((Node)doc, stream);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void addDataFile(Element root, OutputSpooler spooler, String unique, String baseName, long now) {
        String filename = "repodata/" + unique + "-" + baseName + ".xml";
        Element data = XmlHelper.addElement((Element)root, (String)"data");
        data.setAttribute("type", baseName);
        Element checksum = XmlHelper.addElement((Element)data, (String)"checksum", (Object)spooler.getChecksum(String.valueOf(filename) + ".gz", MD_NAME));
        checksum.setAttribute("type", MD_TAG);
        Element openChecksum = XmlHelper.addElement((Element)data, (String)"open-checksum", (Object)spooler.getChecksum(filename, MD_NAME));
        openChecksum.setAttribute("type", MD_TAG);
        Element location = XmlHelper.addElement((Element)data, (String)"location");
        location.setAttribute("href", String.valueOf(filename) + ".gz");
        XmlHelper.addElement((Element)data, (String)"timestamp", (Object)(now / 1000L));
        XmlHelper.addElement((Element)data, (String)"size", (Object)("" + spooler.getSize(String.valueOf(filename) + ".gz")));
        XmlHelper.addElement((Element)data, (String)"open-size", (Object)("" + spooler.getSize(filename)));
    }

    public static interface Context {
        public void addPackage(String var1, ArtifactInformation var2, RpmInformation var3);
    }

    public class ContextImpl
    implements Context {
        private final OutputStream primaryStream;
        private final OutputStream filelistsStream;
        private final OutputStream otherStream;
        private final Document primary;
        private final Document filelists;
        private final Document other;
        private final XmlHelper xml;
        private final Element primaryRoot;
        private final Element filelistsRoot;
        private final Element otherRoot;
        private long count;

        public ContextImpl(OutputStream primaryStream, OutputStream filelistsStream, OutputStream otherStream, XmlHelper xml) {
            this.primaryStream = primaryStream;
            this.filelistsStream = filelistsStream;
            this.otherStream = otherStream;
            this.primary = xml.createNs();
            this.primaryRoot = this.primary.createElementNS("http://linux.duke.edu/metadata/common", "metadata");
            this.primaryRoot.setAttribute("xmlns:rpm", "http://linux.duke.edu/metadata/rpm");
            this.primary.appendChild(this.primaryRoot);
            this.filelists = xml.createNs();
            this.filelistsRoot = this.filelists.createElementNS("http://linux.duke.edu/metadata/filelists", "filelists");
            this.filelists.appendChild(this.filelistsRoot);
            this.other = xml.createNs();
            this.otherRoot = this.other.createElementNS("http://linux.duke.edu/metadata/other", "otherdata");
            this.other.appendChild(this.otherRoot);
            this.xml = xml;
        }

        @Override
        public void addPackage(String sha1, ArtifactInformation artifact, RpmInformation info) {
            if (info == null) {
                return;
            }
            ++this.count;
            this.insertToPrimary(sha1, artifact, info);
            Element pkg = this.createPackage(this.filelistsRoot, sha1, info);
            this.appendFiles(info, pkg, null, null);
            pkg = this.createPackage(this.otherRoot, sha1, info);
            for (RpmInformation.Changelog log : info.getChangelog()) {
                Element cl = XmlHelper.addElement((Element)pkg, (String)"changelog", (Object)log.getText());
                cl.setAttribute("author", log.getAuthor());
                cl.setAttribute("date", "" + log.getTimestamp());
            }
        }

        private void appendFiles(RpmInformation info, Element pkg, Predicate<String> fileFilter, Predicate<String> dirFilter) {
            for (String file : new TreeSet<String>(info.getFiles())) {
                if (fileFilter != null && !fileFilter.test(file)) continue;
                XmlHelper.addElement((Element)pkg, (String)"file", (Object)file);
            }
            for (String dir : new TreeSet<String>(info.getDirectories())) {
                if (dirFilter != null && !dirFilter.test(dir)) continue;
                Element ele = XmlHelper.addElement((Element)pkg, (String)"file", (Object)dir);
                ele.setAttribute("type", "dir");
            }
        }

        private void insertToPrimary(String sha1, ArtifactInformation artifact, RpmInformation info) {
            Element pkg = XmlHelper.addElement((Element)this.primaryRoot, (String)"package");
            pkg.setAttribute("type", "rpm");
            XmlHelper.addElement((Element)pkg, (String)"name", (Object)info.getName());
            XmlHelper.addElement((Element)pkg, (String)"arch", (Object)info.getArchitecture());
            this.addVersion(pkg, info.getVersion());
            Element checksum = XmlHelper.addElement((Element)pkg, (String)"checksum", (Object)sha1);
            checksum.setAttribute("type", "sha");
            checksum.setAttribute("pkgid", "YES");
            XmlHelper.addElement((Element)pkg, (String)"summary", (Object)info.getSummary());
            XmlHelper.addElement((Element)pkg, (String)"description", (Object)info.getDescription());
            XmlHelper.addElement((Element)pkg, (String)"packager", (Object)info.getPackager());
            XmlHelper.addElement((Element)pkg, (String)"url", (Object)info.getUrl());
            Element time = XmlHelper.addElement((Element)pkg, (String)"time");
            time.setAttribute("file", "" + artifact.getCreationTimestamp().getTime() / 1000L);
            if (info.getBuildTimestamp() != null) {
                time.setAttribute("build", "" + info.getBuildTimestamp());
            }
            Element size = XmlHelper.addElement((Element)pkg, (String)"size");
            size.setAttribute("package", "" + artifact.getSize());
            if (info.getInstalledSize() != null) {
                size.setAttribute("installed", "" + info.getInstalledSize());
            }
            if (info.getArchiveSize() != null) {
                size.setAttribute("archive", "" + info.getArchiveSize());
            }
            Element location = XmlHelper.addElement((Element)pkg, (String)"location");
            location.setAttribute("href", String.format("pool/%s/%s", artifact.getId(), artifact.getName()));
            Element fmt = XmlHelper.addElement((Element)pkg, (String)"format");
            XmlHelper.addOptionalElement((Element)fmt, (String)"rpm:license", (Object)info.getLicense());
            XmlHelper.addOptionalElement((Element)fmt, (String)"rpm:vendor", (Object)info.getVendor());
            XmlHelper.addOptionalElement((Element)fmt, (String)"rpm:group", (Object)info.getGroup());
            XmlHelper.addOptionalElement((Element)fmt, (String)"rpm:buildhost", (Object)info.getBuildHost());
            XmlHelper.addOptionalElement((Element)fmt, (String)"rpm:sourcerpm", (Object)info.getSourcePackage());
            Element rng = XmlHelper.addElement((Element)fmt, (String)"rpm:header-range");
            rng.setAttribute("start", "" + info.getHeaderStart());
            rng.setAttribute("end", "" + info.getHeaderEnd());
            this.addDependencies(fmt, "rpm:provides", info.getProvides());
            this.addDependencies(fmt, "rpm:requires", info.getRequires());
            this.addDependencies(fmt, "rpm:conflicts", info.getConflicts());
            this.addDependencies(fmt, "rpm:obsoletes", info.getObsoletes());
            this.appendFiles(info, pkg, file -> RepositoryCreator.this.matches((String)file, RepositoryCreator.this.primaryFiles), dir -> RepositoryCreator.this.matches((String)dir, RepositoryCreator.this.primaryDirs));
        }

        private void addDependencies(Element fmt, String elementName, List<RpmInformation.Dependency> deps) {
            Element ele = XmlHelper.addElement((Element)fmt, (String)elementName);
            for (RpmInformation.Dependency dep : deps) {
                boolean pre;
                EnumSet flags = RpmDependencyFlags.parse((Long)dep.getFlags());
                if (flags.contains(RpmDependencyFlags.RPMLIB)) continue;
                Element entry = XmlHelper.addElement((Element)ele, (String)"rpm:entry");
                entry.setAttribute("name", dep.getName());
                if (dep.getVersion() != null) {
                    RpmVersion version = RpmVersion.valueOf((String)dep.getVersion());
                    entry.setAttribute("epoch", "" + version.getEpoch().orElse(0));
                    entry.setAttribute("ver", version.getVersion());
                    if (version.getRelease().isPresent()) {
                        entry.setAttribute("rel", (String)version.getRelease().get());
                    }
                }
                boolean eq = flags.contains(RpmDependencyFlags.EQUAL);
                if (flags.contains(RpmDependencyFlags.GREATER)) {
                    entry.setAttribute("flags", eq ? "GE" : "GT");
                } else if (flags.contains(RpmDependencyFlags.LESS)) {
                    entry.setAttribute("flags", eq ? "LE" : "LT");
                } else if (eq) {
                    entry.setAttribute("flags", "EQ");
                }
                boolean bl = pre = flags.contains(RpmDependencyFlags.PREREQ) || flags.contains(RpmDependencyFlags.SCRIPT_PRE) || flags.contains(RpmDependencyFlags.SCRIPT_POST);
                if (!pre) continue;
                entry.setAttribute("pre", "1");
            }
        }

        private Element createPackage(Element root, String id, RpmInformation info) {
            Element pkg = XmlHelper.addElement((Element)root, (String)"package");
            pkg.setAttribute("pkgid", id);
            pkg.setAttribute("name", info.getName());
            pkg.setAttribute("arch", info.getArchitecture());
            this.addVersion(pkg, info.getVersion());
            return pkg;
        }

        private Element addVersion(Element pkg, RpmInformation.Version version) {
            if (version == null) {
                return null;
            }
            Element ver = XmlHelper.addElement((Element)pkg, (String)"version");
            if (version.getEpoch() == null || version.getEpoch().isEmpty()) {
                ver.setAttribute("epoch", "0");
            } else {
                ver.setAttribute("epoch", version.getEpoch());
            }
            ver.setAttribute("ver", version.getVersion());
            ver.setAttribute("rel", version.getRelease());
            return ver;
        }

        public void close() throws IOException {
            this.primaryRoot.setAttribute("packages", Long.toString(this.count));
            this.filelistsRoot.setAttribute("packages", Long.toString(this.count));
            this.otherRoot.setAttribute("packages", Long.toString(this.count));
            try {
                this.xml.write((Node)this.primary, this.primaryStream);
                this.xml.write((Node)this.filelists, this.filelistsStream);
                this.xml.write((Node)this.other, this.otherStream);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

