/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.cleanup.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.aspect.cleanup.Aggregator;
import org.eclipse.packagedrone.repo.aspect.cleanup.CleanupConfiguration;
import org.eclipse.packagedrone.repo.aspect.cleanup.CleanupTester;
import org.eclipse.packagedrone.repo.aspect.cleanup.ResultEntry;
import org.eclipse.packagedrone.repo.aspect.cleanup.ResultKey;
import org.eclipse.packagedrone.repo.aspect.cleanup.Sorter;
import org.eclipse.packagedrone.repo.aspect.listener.ChannelListener;
import org.eclipse.packagedrone.repo.aspect.listener.PostAddContext;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupListener
implements ChannelListener {
    private static final Logger logger = LoggerFactory.getLogger(CleanupListener.class);

    public void artifactAdded(PostAddContext context) throws Exception {
        Map metaData = context.getChannelMetaData();
        CleanupConfiguration cfg = (CleanupConfiguration)MetaKeys.bind((Object)new CleanupConfiguration(), (Map)metaData);
        if (cfg.getNumberOfVersions() <= 0 || cfg.getSorter() == null) {
            logger.info("Cleanup is not configured");
            return;
        }
        Map<List<String>, LinkedList<ArtifactInformation>> artifacts = CleanupListener.aggregate(cfg.getAggregator(), cfg.getSorter(), cfg.isOnlyRootArtifacts(), cfg.isRequireAllMatching(), context.getChannelArtifacts());
        SortedMap<ResultKey, List<ResultEntry>> result = CleanupListener.process(cfg, artifacts);
        Set deleteSet = result.values().stream().flatMap(list -> list.stream()).filter(entry -> entry.getAction() == CleanupTester.Action.DELETE).map(entry -> entry.getArtifact().getId()).collect(Collectors.toSet());
        logger.debug("Deleting: {}", deleteSet);
        context.deleteArtifacts(deleteSet);
    }

    static SortedMap<ResultKey, List<ResultEntry>> process(CleanupConfiguration configuration, Map<List<String>, LinkedList<ArtifactInformation>> aggregation) {
        int numVersions = configuration.getNumberOfVersions();
        TreeMap<ResultKey, List<ResultEntry>> result = new TreeMap<ResultKey, List<ResultEntry>>();
        for (Map.Entry<List<String>, LinkedList<ArtifactInformation>> entry : aggregation.entrySet()) {
            ResultKey key = new ResultKey(entry.getKey());
            LinkedList<ResultEntry> value = (LinkedList<ResultEntry>)result.get(key);
            if (value == null) {
                value = new LinkedList<ResultEntry>();
                result.put(key, value);
            }
            int cutOff = entry.getValue().size() - numVersions;
            int i = 0;
            for (ArtifactInformation art : entry.getValue()) {
                CleanupTester.Action action = i < cutOff ? CleanupTester.Action.DELETE : CleanupTester.Action.KEEP;
                value.add(new ResultEntry(art, action));
                ++i;
            }
        }
        return result;
    }

    static Map<List<String>, LinkedList<ArtifactInformation>> aggregate(Aggregator aggregator, Sorter sorter, boolean rootOnly, boolean requireAll, Collection<? extends ArtifactInformation> artifacts) {
        HashMap<List<String>, LinkedList<ArtifactInformation>> result = new HashMap<List<String>, LinkedList<ArtifactInformation>>();
        for (ArtifactInformation artifactInformation : artifacts) {
            List<String> key;
            if (!artifactInformation.is("stored") || rootOnly && artifactInformation.getParentId() != null || (key = aggregator.makeKey(artifactInformation.getMetaData(), requireAll)) == null) continue;
            LinkedList<ArtifactInformation> list = (LinkedList<ArtifactInformation>)result.get(key);
            if (list == null) {
                list = new LinkedList<ArtifactInformation>();
                result.put(key, list);
            }
            list.add(artifactInformation);
        }
        Comparator<ArtifactInformation> comparator = sorter.makeComparator();
        for (LinkedList list : result.values()) {
            Collections.sort(list, comparator);
        }
        return result;
    }
}

