/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.common;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.packagedrone.repo.aspect.ChannelAspect;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectFactory;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;

public class MimeTypeAspectFactory
implements ChannelAspectFactory {
    public static final String ID = "mime";

    public ChannelAspect createAspect() {
        return new ChannelAspectImpl();
    }

    private static class ChannelAspectImpl
    implements ChannelAspect {
        private ChannelAspectImpl() {
        }

        public Extractor getExtractor() {
            return new Extractor(){

                public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
                    String type = this.getMimeType(context.getPath());
                    if (type != null) {
                        metadata.put("type", type);
                    }
                }

                public String getMimeType(Path file) throws IOException {
                    if (file.toString().endsWith(".pom")) {
                        return "application/xml";
                    }
                    return Files.probeContentType(file);
                }
            };
        }

        public String getId() {
            return MimeTypeAspectFactory.ID;
        }
    }
}

