/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class HashHelper {
    private HashHelper() {
    }

    public static Map<String, HashCode> createChecksums(Path file, Map<String, HashFunction> functions) throws IOException {
        if (functions.isEmpty()) {
            return Collections.emptyMap();
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file.toString()));){
            return HashHelper.createChecksums(is, functions);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<String, HashCode> createChecksums(InputStream stream, Map<String, HashFunction> functions) throws IOException {
        int len;
        if (functions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Hasher> hasherMap = new HashMap<String, Hasher>();
        Hasher[] hashers = new Hasher[functions.size()];
        int i = 0;
        for (Map.Entry<String, HashFunction> entry : functions.entrySet()) {
            hashers[i] = entry.getValue().newHasher();
            hasherMap.put(entry.getKey(), hashers[i]);
            ++i;
        }
        byte[] buffer = new byte[4096];
        while ((len = stream.read(buffer)) >= 0) {
            Hasher[] hasherArray = hashers;
            int n = hashers.length;
            int n2 = 0;
            while (n2 < n) {
                Hasher hasher = hasherArray[n2];
                hasher.putBytes(buffer, 0, len);
                ++n2;
            }
        }
        HashMap<String, HashCode> result = new HashMap<String, HashCode>(hashers.length);
        for (Map.Entry entry : hasherMap.entrySet()) {
            result.put((String)entry.getKey(), ((Hasher)entry.getValue()).hash());
        }
        return result;
    }
}

