/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.channel;

import com.google.common.io.ByteStreams;
import com.google.common.net.UrlEscapers;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.transfer.TransferService;
import org.eclipse.packagedrone.repo.channel.web.Tags;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.ProfilerControllerInterceptor;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Secured
@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class), @ControllerInterceptor(value=ProfilerControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class TransferController
implements InterfaceExtender {
    private static final Logger logger = LoggerFactory.getLogger(TransferController.class);
    private static final MessageFormat EXPORT_PATTERN = new MessageFormat("export-channel-{0}-{1,date,yyyyMMdd-HHmm}.zip");
    private static final MessageFormat EXPORT_ALL_PATTERN = new MessageFormat("export-all-{0,date,yyyyMMdd-HHmm}.zip");
    private TransferService transferService;
    private ChannelService channelService;

    public void setTransferService(TransferService transferService) {
        this.transferService = transferService;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    protected ModelAndView performExport(HttpServletResponse response, String filename, IOConsumer<OutputStream> exporter) {
        Path tmp = Files.createTempFile("export-", null, new FileAttribute[0]);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedOutputStream tmpStream = new BufferedOutputStream(new FileOutputStream(tmp.toFile()));){
                exporter.accept((Object)tmpStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            response.setContentLengthLong(tmp.toFile().length());
            response.setContentType("application/zip");
            response.setHeader("Content-Disposition", String.format("attachment; filename=%s", filename));
            throwable = null;
            var6_9 = null;
            try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(tmp.toFile()));){
                ByteStreams.copy((InputStream)inStream, (OutputStream)response.getOutputStream());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            try {
                Files.deleteIfExists(tmp);
                throw throwable;
            }
            catch (IOException e) {
                return CommonController.createError((String)"Failed to export", null, (Throwable)e);
            }
        }
        Files.deleteIfExists(tmp);
        return null;
    }

    @RequestMapping(value={"/channel/{channelId}/export"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView exportChannel(@PathVariable(value="channelId") String channelId, HttpServletResponse response) {
        return this.performExport(response, this.makeExportFileName(channelId), (IOConsumer<OutputStream>)((IOConsumer)stream -> this.transferService.exportChannel(channelId, stream)));
    }

    @RequestMapping(value={"/channel/export"}, method={RequestMethod.GET})
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView exportAll(HttpServletResponse response) {
        return this.performExport(response, this.makeExportFileName(null), (IOConsumer<OutputStream>)((IOConsumer)arg_0 -> ((TransferService)this.transferService).exportAll(arg_0)));
    }

    @RequestMapping(value={"/channel/import"}, method={RequestMethod.GET})
    public ModelAndView importChannel() {
        return new ModelAndView("channel/importChannel");
    }

    @RequestMapping(value={"/channel/import"}, method={RequestMethod.POST})
    public ModelAndView importChannelPost(@RequestParameter(value="file") Part part, @RequestParameter(value="useName", required=false) boolean useName) {
        try {
            ChannelId channelId = this.transferService.importChannel(part.getInputStream(), useName);
            return new ModelAndView("redirect:/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(channelId.getId()) + "/view");
        }
        catch (Exception e) {
            logger.warn("Failed to import", (Throwable)e);
            return CommonController.createError((String)"Import", (String)"Channel", (String)"Failed to import channel", (Throwable)e, null);
        }
    }

    @RequestMapping(value={"/channel/importAll"}, method={RequestMethod.GET})
    public ModelAndView importAll(HttpServletResponse response) {
        return new ModelAndView("channel/importAll");
    }

    @RequestMapping(value={"/channel/importAll"}, method={RequestMethod.POST})
    public ModelAndView importAllPost(@RequestParameter(value="useNames", required=false) boolean useNames, @RequestParameter(value="wipe", required=false) boolean wipe, @RequestParameter(value="file") Part part, @RequestParameter(value="location", required=false) String location) {
        try {
            block12: {
                if (location != null && !location.isEmpty()) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(new File(location)));){
                        this.transferService.importAll((InputStream)stream, useNames, wipe);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                this.transferService.importAll(part.getInputStream(), useNames, wipe);
            }
            return new ModelAndView("redirect:/channel");
        }
        catch (Exception e) {
            logger.warn("Failed to import", (Throwable)e);
            return CommonController.createError((String)"Import", (String)"Channel", (String)"Failed to import channel", (Throwable)e, null);
        }
    }

    private String makeExportFileName(String channelId) {
        if (channelId != null) {
            return EXPORT_PATTERN.format(new Object[]{channelId, new Date()});
        }
        return EXPORT_ALL_PATTERN.format(new Object[]{new Date()});
    }

    public List<MenuEntry> getActions(HttpServletRequest request, Object object) {
        if (object instanceof ChannelInformation) {
            ChannelInformation channel = (ChannelInformation)object;
            HashMap<String, String> model = new HashMap<String, String>(1);
            model.put("channelId", channel.getId());
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            if (request.getRemoteUser() != null) {
                result.add(new MenuEntry("Maintenance", 160, "Export channel", 200, LinkTarget.createFromController(TransferController.class, (String)"exportChannel").expand(model), Modifier.DEFAULT, "export"));
            }
            return result;
        }
        if (Tags.ACTION_TAG_CHANNELS.equals(object)) {
            LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
            if (request.isUserInRole("MANAGER")) {
                result.add(new MenuEntry("Maintenance", 160, "Import channel", 200, LinkTarget.createFromController(TransferController.class, (String)"importChannel"), Modifier.DEFAULT, "import"));
                result.add(new MenuEntry("Maintenance", 160, "Export all channels", 300, LinkTarget.createFromController(TransferController.class, (String)"exportAll"), Modifier.DEFAULT, "export"));
            }
            return result;
        }
        return null;
    }
}

