/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiExtractor;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.util.DownloadHelper;
import org.eclipse.packagedrone.repo.servlet.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(DownloadHandler.class);
    private final String channelId;
    private final String id;
    private final String version;
    private final String filename;
    private final String classifier;
    private final ChannelService service;

    public DownloadHandler(String channelId, ChannelService service, String id, String version, String filename, String classifier) {
        this.channelId = channelId;
        this.service = service;
        this.id = id;
        this.version = version;
        this.filename = filename;
        this.classifier = classifier;
    }

    public void process(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Looking for bundle: {}/{}", (Object)this.id, (Object)this.version);
        this.service.accessRun(ChannelService.By.id((String)this.channelId), ReadableChannel.class, channel -> {
            for (ArtifactInformation a : channel.getContext().getArtifacts().values()) {
                Map md = a.getMetaData();
                String thisClassifier = (String)md.get(OsgiExtractor.KEY_CLASSIFIER);
                String thisId = (String)md.get(OsgiExtractor.KEY_NAME);
                String thisVersion = (String)md.get(OsgiExtractor.KEY_VERSION);
                logger.debug("This - id: {}, version: {}, classifier: {}", new Object[]{thisId, thisVersion, thisClassifier});
                if (thisClassifier == null || !thisClassifier.equals(this.classifier) || thisId == null || !thisId.equals(this.id) || thisVersion == null || !thisVersion.equals(this.version)) continue;
                logger.debug("Streaming artifact: {} / {} ", (Object)a.getName(), (Object)a.getId());
                DownloadHelper.streamArtifact((HttpServletResponse)resp, (ChannelService)this.service, (String)this.channelId, (String)a.getId(), Optional.empty(), (boolean)true, art -> this.filename);
                return;
            }
            String message = String.format("Artifact not found - name: %s, version: %s, classifier: %s", this.id, this.version, this.classifier);
            logger.warn(message);
            resp.setStatus(404);
            resp.setContentType("text/plain");
            resp.getWriter().println(message);
        });
    }
}

