/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceServlet
extends HttpServlet
implements ResourceFactory {
    private static final int SECOND = 1000;
    private static final long serialVersionUID = 1L;
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String IF_MATCH = "If-Match";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_RANGE = "If-Range";
    private static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String ETAG = "ETag";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServlet.class);
    private final HttpContext httpContext;
    private final String contextName;
    private final String alias;
    private final String name;
    private final MimeTypes mimeTypes = new MimeTypes();
    private String[] welcomes;

    ResourceServlet(HttpContext httpContext, String contextName, String alias, String name) {
        this.httpContext = httpContext;
        this.contextName = "/" + contextName;
        this.alias = alias;
        this.name = "/".equals(name) ? "" : name;
    }

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        ContextHandler contextHandler = this.initContextHandler(servletContext);
        this.welcomes = contextHandler.getWelcomeFiles();
        if (this.welcomes == null) {
            this.welcomes = new String[]{"index.html", "index.jsp"};
        }
    }

    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        if (scontext == null) {
            if (servletContext instanceof ContextHandler.Context) {
                return ((ContextHandler.Context)servletContext).getContextHandler();
            }
            throw new IllegalArgumentException("The servletContext " + servletContext + " " + servletContext.getClass().getName() + " is not " + ContextHandler.Context.class.getName());
        }
        return ContextHandler.getCurrentContext().getContextHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mapping;
        if (response.isCommitted()) {
            return;
        }
        Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
        String pathInfo = null;
        if (included != null && included.booleanValue()) {
            String servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
            mapping = URIUtil.addPaths((String)servletPath, (String)pathInfo);
        } else {
            included = Boolean.FALSE;
            if (this.contextName.equals(this.alias)) {
                mapping = !"default".equalsIgnoreCase(this.name) ? this.name + request.getRequestURI() : request.getRequestURI();
            } else {
                mapping = request.getRequestURI().replaceFirst(this.contextName, "/");
                if (!"default".equalsIgnoreCase(this.name)) {
                    mapping = mapping.replaceFirst(this.alias, Matcher.quoteReplacement(this.name));
                }
                pathInfo = request.getPathInfo();
            }
        }
        boolean endsWithSlash = (mapping == null ? request.getServletPath() : mapping).endsWith("/");
        URL url = this.httpContext.getResource(mapping);
        if (url == null) {
            response.sendError(404);
            return;
        }
        Resource resource = this.getResource(mapping);
        try {
            ServletOutputStream out;
            long modifiedSince;
            if (!(resource != null && resource.exists() || endsWithSlash)) {
                if (!response.isCommitted()) {
                    response.sendError(404);
                }
                return;
            }
            if (resource.isDirectory() && !mapping.equals("//") && resource.isDirectory() && !mapping.equals("/")) {
                response.sendError(403);
                return;
            }
            String welcome = this.getWelcomeFile(mapping);
            boolean redirect = false;
            if (null != welcome) {
                LOG.debug("welcome={}", (Object)welcome);
                if (redirect && response instanceof HttpServletResponse) {
                    response.sendRedirect(welcome);
                    return;
                }
                RequestDispatcher dispatcher = request.getRequestDispatcher(welcome);
                if (dispatcher != null) {
                    if (included.booleanValue()) {
                        dispatcher.include((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    request.setAttribute("org.eclipse.jetty.server.welcome", (Object)welcome);
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            } else if (resource == null || !resource.exists() || resource.isDirectory() && mapping.equals("//") || resource.isDirectory() && mapping.equals("/")) {
                if (!response.isCommitted()) {
                    response.sendError(404);
                }
                return;
            }
            String eTag = String.valueOf(resource.lastModified());
            if (request.getHeader(IF_NONE_MATCH) != null && eTag.equals(request.getHeader(IF_NONE_MATCH))) {
                response.setStatus(304);
                return;
            }
            if (request.getHeader(IF_MODIFIED_SINCE) != null) {
                long ifModifiedSince = request.getDateHeader(IF_MODIFIED_SINCE);
                if (resource.lastModified() != -1L && resource.lastModified() / 1000L <= ifModifiedSince / 1000L) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return;
                }
            } else if (request.getHeader(IF_UNMODIFIED_SINCE) != null && (modifiedSince = request.getDateHeader(IF_UNMODIFIED_SINCE)) != -1L && resource.lastModified() / 1000L > modifiedSince / 1000L) {
                response.sendError(412);
                return;
            }
            response.setHeader(ETAG, eTag);
            String mimeType = this.httpContext.getMimeType(mapping);
            if (mimeType == null) {
                mimeType = this.mimeTypes.getMimeByExtension(mapping);
            }
            if (mimeType == null) {
                try {
                    mimeType = url.openConnection().getContentType();
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            if (mimeType == null) {
                ServletContext servletContext = this.getServletConfig().getServletContext();
                mimeType = servletContext.getMimeType(mapping);
            }
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            if ((out = response.getOutputStream()) != null) {
                if (out instanceof HttpOutput) {
                    ((HttpOutput)out).sendContent(resource.getInputStream());
                } else {
                    resource.writeTo((OutputStream)out, 0L, resource.length());
                }
            }
            response.setStatus(200);
        }
        finally {
            resource.release();
        }
    }

    private String getWelcomeFile(String pathInContext) throws MalformedURLException, IOException {
        if (this.welcomes == null) {
            return null;
        }
        String welcomeServlet = null;
        for (int i = 0; i < this.welcomes.length; ++i) {
            String welcomeInContext = URIUtil.addPaths((String)pathInContext, (String)this.welcomes[i]);
            URL url = this.httpContext.getResource(welcomeInContext);
            Resource welcome = ResourceEx.newResource(url, true);
            if (welcome == null || !welcome.exists()) continue;
            return this.welcomes[i];
        }
        return welcomeServlet;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + "context=" + this.contextName + ",alias=" + this.alias + ",name=" + this.name + "}";
    }

    public Resource getResource(String path) {
        URL url = this.httpContext.getResource(path);
        if (url == null) {
            return null;
        }
        try {
            return ResourceEx.newResource(url, true);
        }
        catch (IOException e) {
            this.log("failed to retrieve Resource for URL:" + url, e);
            return null;
        }
    }

    public static abstract class ResourceEx
    extends Resource {
        private static final Method METHOD;

        public static Resource newResource(URL url, boolean useCaches) throws IOException {
            try {
                return (Resource)METHOD.invoke(null, url, useCaches);
            }
            catch (Throwable t) {
                return Resource.newResource((URL)url);
            }
        }

        static {
            Method mth = null;
            try {
                mth = Resource.class.getDeclaredMethod("newResource", URL.class, Boolean.TYPE);
                mth.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            METHOD = mth;
        }
    }
}

