/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.npm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.npm.PackageInfo;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.manage.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleHandler {
    private static final MetaKey KEY_NPM_PACKAGE_JSON = new MetaKey("npm", "package.json");
    private static final MetaKey KEY_SHA1 = new MetaKey("hasher", "sha1");
    private static final Logger logger = LoggerFactory.getLogger(ModuleHandler.class);
    private final ReadableChannel channel;
    private final String moduleName;
    private final boolean pretty;
    private final SystemService service;

    public ModuleHandler(SystemService service, ReadableChannel channel, String moduleName, boolean pretty) {
        this.service = service;
        this.channel = channel;
        this.moduleName = moduleName;
        this.pretty = pretty;
    }

    public void process(HttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        this.process((OutputStream)response.getOutputStream());
    }

    public void process(OutputStream stream) throws IOException {
        String sitePrefix = this.service.getDefaultSitePrefix();
        GsonBuilder builder = new GsonBuilder();
        if (this.pretty) {
            builder.setPrettyPrinting();
        }
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Gson gson = builder.create();
        JsonParser parser = new JsonParser();
        TreeMap<String, PackageEntry> versions = new TreeMap<String, PackageEntry>();
        for (ArtifactInformation art : this.channel.getArtifacts()) {
            String pkg = (String)art.getMetaData().get(KEY_NPM_PACKAGE_JSON);
            if (pkg == null) continue;
            try {
                JsonElement pkgEle = parser.parse(pkg);
                PackageInfo pi = (PackageInfo)gson.fromJson(pkgEle, PackageInfo.class);
                if (!this.moduleName.equals(pi.getName())) continue;
                versions.put(pi.getVersion(), new PackageEntry(pi, pkgEle, art));
            }
            catch (Exception e) {
                logger.info("Failed to parse package.json of " + art.getId(), (Throwable)e);
            }
        }
        JsonObject main = new JsonObject();
        main.addProperty("name", this.moduleName);
        if (!versions.isEmpty()) {
            Map.Entry mostRecent = versions.lastEntry();
            PackageInfo pi = ((PackageEntry)mostRecent.getValue()).getInfo();
            main.addProperty("license", pi.getLicense());
            JsonObject distTags = new JsonObject();
            main.add("dist-tags", (JsonElement)distTags);
            distTags.addProperty("latest", pi.getVersion());
        }
        JsonObject times = new JsonObject();
        main.add("time", (JsonElement)times);
        JsonObject versionsEle = new JsonObject();
        main.add("versions", (JsonElement)versionsEle);
        for (Map.Entry entry : versions.entrySet()) {
            PackageInfo pi = ((PackageEntry)entry.getValue()).getInfo();
            ArtifactInformation art = ((PackageEntry)entry.getValue()).getArtifact();
            times.add(pi.getVersion(), gson.toJsonTree((Object)art.getCreationTimestamp()));
            JsonObject ele = (JsonObject)((PackageEntry)entry.getValue()).getElement();
            JsonObject dist = new JsonObject();
            dist.addProperty("shasum", (String)art.getMetaData().get(KEY_SHA1));
            dist.addProperty("tarball", String.format("%s/artifact/%s/dump", sitePrefix, art.getId()));
            ele.add("dist", (JsonElement)dist);
            versionsEle.add(pi.getVersion(), (JsonElement)ele);
        }
        Throwable throwable = null;
        Iterator iterator = null;
        try (OutputStreamWriter out = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            gson.toJson((JsonElement)main, (Appendable)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static class PackageEntry {
        private final JsonElement element;
        private final PackageInfo info;
        private final ArtifactInformation artifact;

        public PackageEntry(PackageInfo info, JsonElement element, ArtifactInformation artifact) {
            this.info = info;
            this.element = element;
            this.artifact = artifact;
        }

        public ArtifactInformation getArtifact() {
            return this.artifact;
        }

        public JsonElement getElement() {
            return this.element;
        }

        public PackageInfo getInfo() {
            return this.info;
        }
    }
}

