/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.EnumSet;

public enum RpmDependencyFlags {
    LESS(1),
    GREATER(2),
    EQUAL(3),
    PREREQ(6),
    SCRIPT_PRE(9),
    SCRIPT_POST(10),
    RPMLIB(24);

    private int value;

    private RpmDependencyFlags(int bit) {
        this.value = 1 << bit;
    }

    public static EnumSet<RpmDependencyFlags> parse(Long flags) {
        if (flags == null) {
            return null;
        }
        return RpmDependencyFlags.parse(flags.intValue());
    }

    public static EnumSet<RpmDependencyFlags> parse(int flags) {
        EnumSet<RpmDependencyFlags> result = EnumSet.noneOf(RpmDependencyFlags.class);
        RpmDependencyFlags[] rpmDependencyFlagsArray = RpmDependencyFlags.values();
        int n = rpmDependencyFlagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            RpmDependencyFlags f = rpmDependencyFlagsArray[n2];
            if ((flags & f.value) > 0) {
                result.add(f);
            }
            ++n2;
        }
        return result;
    }
}

