/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.ci;

import com.google.common.html.HtmlEscapers;
import java.net.URI;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.utils.MapOnce;
import org.eclipse.packagedrone.web.common.table.TableColumn;
import org.eclipse.packagedrone.web.common.table.TableColumnProvider;
import org.eclipse.packagedrone.web.common.table.TableDescriptor;
import org.eclipse.packagedrone.web.common.table.TableExtender;

public class BuildUrlExtender
implements TableExtender {
    private static final @NonNull TableColumn COLUMN_URL = new TableColumn("ci-link", -10000, "CI", "Continous Integration");
    private static final @NonNull MetaKey KEY_JENKINS_NUMBER = new MetaKey("jenkins", "buildNumber");
    private static final @NonNull MetaKey KEY_JENKINS_JOB_NAME = new MetaKey("jenkins", "jobName");
    private static final @NonNull MetaKey KEY_JENKINS_URL = new MetaKey("jenkins", "buildUrl");
    private static final @NonNull String SERVER_NAME_JENKINS = "Jenkins";
    private static final @NonNull MetaKey KEY_HUDSON_NUMBER = new MetaKey("hudson", "buildNumber");
    private static final @NonNull MetaKey KEY_HUDSON_URL = new MetaKey("hudson", "buildUrl");
    private static final @NonNull MetaKey KEY_HUDSON_JOB_NAME = new MetaKey("hudson", "jobName");
    private static final @NonNull String SERVER_NAME_HUDSON = "Hudson";

    public void getColumns(@NonNull HttpServletRequest request, @NonNull TableDescriptor descriptor, @NonNull Consumer<TableColumnProvider> columnReceiver) {
        if (!descriptor.hasTag("artifacts")) {
            return;
        }
        columnReceiver.accept(TableColumnProvider.stringProvider((TableColumn)COLUMN_URL, ArtifactInformation.class, BuildUrlExtender::buildLink));
    }

    protected static String buildLink(ArtifactInformation art) {
        if (art == null) {
            return null;
        }
        MapOnce map = new MapOnce((Object)art);
        map.map(BuildUrlExtender::fromHudson);
        map.map(BuildUrlExtender::fromJenkins);
        return (String)map.get();
    }

    protected static String fromJenkins(ArtifactInformation art) {
        return BuildUrlExtender.fromUrlAndNumber(art, KEY_JENKINS_URL, KEY_JENKINS_NUMBER, KEY_JENKINS_JOB_NAME, SERVER_NAME_JENKINS);
    }

    protected static String fromHudson(ArtifactInformation art) {
        return BuildUrlExtender.fromUrlAndNumber(art, KEY_HUDSON_URL, KEY_HUDSON_NUMBER, KEY_HUDSON_JOB_NAME, SERVER_NAME_HUDSON);
    }

    private static String fromUrlAndNumber(ArtifactInformation art, @NonNull MetaKey keyUrl, @NonNull MetaKey keyNumber, @NonNull MetaKey keyJobName, @NonNull String serverName) {
        String url = (String)art.getMetaData().get(keyUrl);
        String number = (String)art.getMetaData().get(keyNumber);
        String jobName = (String)art.getMetaData().get(keyJobName);
        if (url == null || url.isEmpty() || number == null || number.isEmpty()) {
            return null;
        }
        try {
            new URI(url);
            Long.parseLong(number);
        }
        catch (Exception exception) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<a target=\"_blank\" href=\"").append(url).append("\"");
        if (jobName != null && !jobName.isEmpty()) {
            sb.append(" title=\"");
            sb.append(HtmlEscapers.htmlEscaper().escape(String.format("Build #%s of job '%s' on %s", jobName, serverName)));
            sb.append("\"");
        } else {
            sb.append(String.format("title=\"%s build link\"", serverName));
        }
        sb.append(">");
        sb.append("#").append(number);
        sb.append("</a>");
        return sb.toString();
    }
}

