/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.googlebot;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.web.googlebot.GoogleBotWrapper;

public class GoogleBotFilter
implements Filter {
    private static final String USER_AGENT_HEADER_NAME = "User-Agent";
    private static final String GOOGLE_BOT_FRAGMENT = System.getProperty("drone.web.googlebot.fragment", "googlebot").toLowerCase();

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (GoogleBotFilter.isGoogleBot(request) && response instanceof HttpServletResponse) {
            chain.doFilter(request, (ServletResponse)new GoogleBotWrapper((HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }

    protected static boolean isGoogleBot(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            Enumeration headers = httpRequest.getHeaders(USER_AGENT_HEADER_NAME);
            while (headers.hasMoreElements()) {
                String header = (String)headers.nextElement();
                if (header == null || !header.toLowerCase().contains(GOOGLE_BOT_FRAGMENT)) continue;
                return true;
            }
        }
        return false;
    }
}

