/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstanceModel;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstanceModelAccess;
import org.eclipse.packagedrone.storage.apm.AbstractSimpleStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.util.ReplaceOnCloseWriter;

public class ChannelInstanceModelProvider
extends AbstractSimpleStorageModelProvider<ChannelInstanceModelAccess, ChannelInstanceModel> {
    private final String channelId;

    public ChannelInstanceModelProvider(String channelId) {
        super(ChannelInstanceModelAccess.class, ChannelInstanceModel.class);
        this.channelId = channelId;
    }

    protected ChannelInstanceModelAccess makeViewModelTyped(ChannelInstanceModel writeModel) {
        return new ChannelInstanceModel(writeModel);
    }

    protected ChannelInstanceModel cloneWriteModel(ChannelInstanceModel writeModel) {
        return new ChannelInstanceModel(writeModel);
    }

    private static Gson createGson() {
        GsonBuilder gb = new GsonBuilder();
        gb.setPrettyPrinting();
        return gb.create();
    }

    protected void persistWriteModel(StorageContext context, ChannelInstanceModel writeModel) throws Exception {
        if (!writeModel.isModified()) {
            return;
        }
        Gson gson = ChannelInstanceModelProvider.createGson();
        Path path = this.makePath(context);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ReplaceOnCloseWriter writer = new ReplaceOnCloseWriter(path, StandardCharsets.UTF_8);){
            gson.toJson((Object)writeModel, (Appendable)writer);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected ChannelInstanceModel loadWriteModel(StorageContext context) throws Exception {
        Path path = this.makePath(context);
        Gson gson = ChannelInstanceModelProvider.createGson();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedReader reader = Files.newBufferedReader(path);){
                return (ChannelInstanceModel)gson.fromJson((Reader)reader, ChannelInstanceModel.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return new ChannelInstanceModel();
        }
    }

    private Path makePath(StorageContext context) {
        return context.getBasePath().resolve("channel.cfg").resolve(String.valueOf(this.channelId) + ".json");
    }
}

