/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.common;

import com.google.common.html.HtmlEscapers;
import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.packagedrone.mail.MailService;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.scada.utils.str.StringReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityMailService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityMailService.class);
    private MailService mailService;
    private SitePrefixService sitePrefixService;

    public void setSitePrefixService(SitePrefixService sitePrefixService) {
        this.sitePrefixService = sitePrefixService;
    }

    public void setMailService(MailService mailService) {
        this.mailService = mailService;
    }

    public void unsetMailService(MailService mailService) {
        this.mailService = null;
    }

    public void sendResetEmail(String email, String resetToken) {
        String link;
        try {
            link = String.format("%s/signup/newPassword?email=%s&token=%s", this.getSitePrefix(), URLEncoder.encode(email, "UTF-8"), resetToken);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("token", resetToken);
        model.put("link", link);
        model.put("linkEncoded", HtmlEscapers.htmlEscaper().escape(link));
        this.sendEmail(email, "Password reset request", "passwordReset", model);
    }

    public void sendEmail(String email, String subject, String resource, Map<String, ?> model) {
        MailService mailService = this.mailService;
        if (mailService == null) {
            throw new IllegalStateException("Failed to send e-mail. Mail service not present!");
        }
        URL url = SecurityMailService.class.getResource(String.format("mails/%s.txt", resource));
        if (url == null) {
            logger.info("Failed to load mail content");
            throw new IllegalStateException(String.format("Unable to find message content: %s", resource));
        }
        URL urlHtml = SecurityMailService.class.getResource(String.format("mails/%s.html", resource));
        String data = this.loadAndFill(resource, model, url);
        String dataHtml = this.loadAndFill(resource, model, urlHtml);
        try {
            mailService.sendMessage(email, subject, data, dataHtml);
        }
        catch (Exception e) {
            logger.warn("Failed to send e-mail to: " + email, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadAndFill(String resource, Map<String, ?> model, URL url) {
        String data;
        block16: {
            if (url == null) {
                return null;
            }
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    InputStream is = url.openStream();
                    try {
                        try (InputStreamReader r = new InputStreamReader(is, StandardCharsets.UTF_8);){
                            data = CharStreams.toString((Readable)r);
                        }
                        if (is == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (Exception e) {
                logger.warn("Failed to process mail content", (Throwable)e);
                throw new RuntimeException("Failed to load mail content: " + resource, e);
            }
        }
        if (model == null) return data;
        return StringReplacer.replace((String)data, (StringReplacer.ReplaceSource)StringReplacer.newExtendedSource(model), (Pattern)StringReplacer.DEFAULT_PATTERN, (boolean)true);
    }

    public void sendVerifyEmail(String email, String userId, String token) {
        String link = String.format("%s/signup/verifyEmail?userId=%s&token=%s", this.getSitePrefix(), userId, token);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("token", token);
        model.put("link", link);
        model.put("linkEncoded", HtmlEscapers.htmlEscaper().escape(link));
        this.sendEmail(email, "Verify your account", "verify", model);
    }

    protected String getSitePrefix() {
        return this.sitePrefixService.getSitePrefix();
    }
}

