/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone;

import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

public final class VersionInformation {
    public static final String VERSION;
    public static final String VERSION_UNQUALIFIED;
    public static final String PRODUCT = "Eclipse Package Drone";
    public static final String VERSIONED_PRODUCT;
    public static final String USER_AGENT;
    public static final Optional<String> BUILD_ID;

    static {
        Version version = FrameworkUtil.getBundle(VersionInformation.class).getVersion();
        VERSION = version.toString();
        VERSION_UNQUALIFIED = new Version(version.getMajor(), version.getMinor(), version.getMicro()).toString();
        VERSIONED_PRODUCT = "Eclipse Package Drone " + VERSION;
        USER_AGENT = String.format("PackageDrone/%s (+http://packagedrone.org)", VERSION_UNQUALIFIED);
        BUILD_ID = Optional.ofNullable(VersionInformation.loadBuildId());
    }

    private VersionInformation() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadBuildId() {
        try {
            URL versionProps = FrameworkUtil.getBundle(VersionInformation.class).getEntry("version.properties");
            if (versionProps == null) return null;
            Properties p = new Properties();
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                InputStream input = versionProps.openStream();
                try {
                    p.load(input);
                    String value = p.getProperty("buildId");
                    if (value == null) return null;
                    if (value.isEmpty()) {
                        return null;
                    }
                    return value;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (input == null) return null;
                    input.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

