/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common.foobar;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.io.PrintWriter;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.trigger.Processor;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactory;
import org.eclipse.packagedrone.repo.trigger.common.foobar.FooBarConfiguration;
import org.eclipse.packagedrone.repo.trigger.common.foobar.FooBarConfigurationController;
import org.eclipse.packagedrone.web.LinkTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FooBarProcessorFactory
implements ProcessorFactory {
    private static final Class<?>[] SUPPORTED_CONTEXTS = new Class[]{ModifiableChannel.class};
    private static final Logger logger = LoggerFactory.getLogger(FooBarProcessorFactory.class);
    public static final String ID = "foobar";

    public Class<?>[] getSupportedContexts() {
        return SUPPORTED_CONTEXTS;
    }

    public Processor create(String configuration) throws IllegalArgumentException {
        final FooBarConfiguration cfg = FooBarConfiguration.fromJson(configuration);
        return new Processor(){

            public void process(Object context) {
                System.out.format("Foo bar: %s - %s%n", cfg.getString1(), context);
            }

            public void streamHtmlState(PrintWriter writer) {
                Escaper esc = HtmlEscapers.htmlEscaper();
                writer.format("<p>This action is doing foo bar: <code>%s</code></p>", esc.escape(cfg.getString1()));
            }
        };
    }

    public String getLabel() {
        return "Foo bar";
    }

    public String getDescription() {
        return "Doing a lot of foo bar";
    }

    public String getConfigurationUrl() {
        try {
            return LinkTarget.createFromController(FooBarConfigurationController.class, (String)"configure").getUrl();
        }
        catch (Exception e) {
            logger.warn("Failed to generate configuration url", (Throwable)e);
            return null;
        }
    }
}

