/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.web.controller;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.function.BiFunction;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.sec.web.controller.AbstractSecurityControllerInterceptor;
import org.eclipse.packagedrone.web.RequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContraintControllerInterceptor
extends AbstractSecurityControllerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(HttpContraintControllerInterceptor.class);

    public RequestHandler before(Object controller, Method m, HttpServletRequest request, HttpServletResponse response, BiFunction<HttpServletRequest, HttpServletResponse, RequestHandler> next) throws Exception {
        HttpConstraint s = m.getAnnotation(HttpConstraint.class);
        if (s == null) {
            s = controller.getClass().getAnnotation(HttpConstraint.class);
        }
        logger.trace("Checking http contraints: {} for {}", (Object)s, (Object)request);
        if (s == null) {
            return next.apply(request, response);
        }
        if (HttpContraintControllerInterceptor.isAllowed(s, request)) {
            return next.apply(request, response);
        }
        Principal p = request.getUserPrincipal();
        if (p == null) {
            return this.handleLoginRequired(request, response);
        }
        return this.handleAccessDenied(response);
    }

    public static boolean isAllowed(HttpConstraint constraint, HttpServletRequest request) {
        ServletSecurity.EmptyRoleSemantic empty = constraint.value();
        String[] allowedRoles = constraint.rolesAllowed();
        if (allowedRoles == null || allowedRoles.length <= 0) {
            return ServletSecurity.EmptyRoleSemantic.PERMIT.equals((Object)empty);
        }
        String[] stringArray = allowedRoles;
        int n = allowedRoles.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (request.isUserInRole(role)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

