/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.storage.apm;

import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.packagedrone.storage.apm.AbstractSimpleGsonStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageContext;

public abstract class AbstractSimplerGsonStorageModelProvider<V, W, G>
extends AbstractSimpleGsonStorageModelProvider<V, W, G> {
    private final String fileName;
    private final Supplier<W> newWriteModel;
    private final Function<W, W> cloneWriteModel;
    private final Function<W, V> makeViewModel;

    public AbstractSimplerGsonStorageModelProvider(Class<W> writeClazz, Class<G> gsonModelClass, String fileName, Supplier<W> newWriteModel, Function<W, W> cloneWriteModel, Function<W, V> makeViewModel) {
        super(writeClazz, gsonModelClass);
        this.fileName = Objects.requireNonNull(fileName);
        this.newWriteModel = Objects.requireNonNull(newWriteModel);
        this.cloneWriteModel = Objects.requireNonNull(cloneWriteModel);
        this.makeViewModel = Objects.requireNonNull(makeViewModel);
    }

    public AbstractSimplerGsonStorageModelProvider(Class<V> viewClazz, Class<W> writeClazz, Class<G> gsonModelClass, String fileName, Supplier<W> newWriteModel, Function<W, W> cloneWriteModel) {
        super(writeClazz, gsonModelClass);
        this.fileName = Objects.requireNonNull(fileName);
        this.newWriteModel = Objects.requireNonNull(newWriteModel);
        this.cloneWriteModel = Objects.requireNonNull(cloneWriteModel);
        this.makeViewModel = writeModel -> this.defaultMakeViewModelTyped(writeModel, viewClazz);
    }

    private V defaultMakeViewModelTyped(W writeModel, Class<V> viewClazz) {
        Object viewModel = this.cloneWriteModel(writeModel);
        Object proxyInstance = Proxy.newProxyInstance(writeModel.getClass().getClassLoader(), new Class[]{viewClazz}, (proxy, method, args) -> method.invoke(viewModel, args));
        return viewClazz.cast(proxyInstance);
    }

    @Override
    protected W createNewModel() {
        return this.newWriteModel.get();
    }

    @Override
    protected Path makePath(StorageContext context) {
        return context.getBasePath().resolve(this.fileName);
    }

    @Override
    protected W cloneWriteModel(W writeModel) {
        if (writeModel == null) {
            return this.createNewModel();
        }
        return this.cloneWriteModel.apply(writeModel);
    }

    @Override
    protected V makeViewModelTyped(W writeModel) {
        return this.makeViewModel.apply(writeModel);
    }
}

