/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.addon.internal;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.addon.Addon;
import org.eclipse.packagedrone.addon.AddonManager;
import org.eclipse.packagedrone.addon.State;
import org.eclipse.packagedrone.addon.internal.AddonImpl;
import org.eclipse.packagedrone.addon.internal.AddonRegistration;
import org.eclipse.packagedrone.addon.internal.DefaultAddonRegistration;
import org.eclipse.packagedrone.addon.internal.Watcher;
import org.eclipse.packagedrone.utils.Suppressed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonManagerImpl
implements AddonManager {
    private static final String SUFFIX_ENABLE = ".enable";
    private static final String EXTENSION_ADDON = ".addon";
    private static final String EXTENSION_ADDON_ENABLED = ".addon.enable";
    private static final Logger logger = LoggerFactory.getLogger(AddonManagerImpl.class);
    private final Path path;
    private final Watcher watcher;
    private ExecutorService executor;
    private final Map<String, AddonRegistration> addons = new HashMap<String, AddonRegistration>();

    public AddonManagerImpl(Path path) throws IOException {
        this.path = path;
        this.watcher = new Watcher(path, this::handleEvent);
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "AddonManager/Worker");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Suppressed s = new Suppressed("Failed to shut down addon manager", RuntimeException::new);){
            s.close((Closeable)this.watcher);
            AddonManagerImpl addonManagerImpl = this;
            synchronized (addonManagerImpl) {
                s.run(this.executor::shutdown);
                for (AddonRegistration reg : this.addons.values()) {
                    reg.stop();
                }
                this.addons.clear();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void handleEvent(Path path, Watcher.Event event) {
        logger.warn("Handle event: {} -> {}", (Object)event, (Object)path);
        if (path.toString().endsWith(EXTENSION_ADDON)) {
            this.handleAddon(path, event);
        } else if (path.toString().endsWith(EXTENSION_ADDON_ENABLED)) {
            this.handleDisabled(path, event);
        }
    }

    private void handleAddon(Path path, Watcher.Event event) {
        String addonName = path.getFileName().toString();
        switch (event) {
            case ADDED: {
                this.executor.execute(() -> this.internalAdd(addonName));
                break;
            }
            case REMOVED: {
                this.executor.execute(() -> this.internalRemove(addonName));
                break;
            }
            case MODIFIED: {
                this.executor.execute(() -> {
                    this.internalRemove(addonName);
                    this.internalAdd(addonName);
                });
                break;
            }
        }
    }

    private static String removeSuffix(String string, String suffix) {
        if (string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    private void handleDisabled(Path path, Watcher.Event event) {
        String addonName = AddonManagerImpl.removeSuffix(path.getFileName().toString(), SUFFIX_ENABLE);
        switch (event) {
            case ADDED: {
                this.executor.execute(() -> this.internalEnable(addonName));
                break;
            }
            case REMOVED: {
                this.executor.execute(() -> this.internalDisable(addonName));
                break;
            }
            case MODIFIED: {
                break;
            }
        }
    }

    private boolean isEnabled(String addonName) {
        return Files.exists(this.path.resolve(String.valueOf(addonName) + SUFFIX_ENABLE), new LinkOption[0]);
    }

    private synchronized void internalAdd(String addonName) {
        logger.warn("Add: {}", (Object)addonName);
        DefaultAddonRegistration addon = new DefaultAddonRegistration(this.path.resolve(addonName));
        AddonRegistration oldAddon = this.addons.put(addonName, addon);
        if (oldAddon != null) {
            oldAddon.stop();
        }
        if (this.isEnabled(addonName)) {
            logger.warn("Addon is initially enabled");
            if (addon.getInformation().getState() == State.INSTALLED) {
                addon.start();
            }
        }
    }

    private synchronized void internalRemove(String addonName) {
        logger.warn("Remove: {}", (Object)addonName);
        AddonRegistration addon = this.addons.remove(addonName);
        if (addon != null) {
            addon.stop();
        }
    }

    private synchronized void internalEnable(String addonName) {
        logger.warn("Enable addon: {}", (Object)addonName);
        AddonRegistration addon = this.addons.get(addonName);
        if (addon != null) {
            addon.start();
        }
    }

    private synchronized void internalDisable(String addonName) {
        logger.warn("Disable addon: {}", (Object)addonName);
        AddonRegistration addon = this.addons.get(addonName);
        if (addon != null) {
            addon.stop();
        }
    }

    @Override
    public Addon install(URI uri) {
        return null;
    }

    @Override
    public synchronized List<Addon> list() {
        return this.addons.values().stream().map(this::toAddon).collect(Collectors.toList());
    }

    @Override
    public synchronized Optional<Addon> getAddon(String id) {
        return Optional.ofNullable(this.addons.get(id)).map(this::toAddon);
    }

    private Addon toAddon(AddonRegistration registration) {
        if (registration == null) {
            return null;
        }
        return new AddonImpl(registration);
    }
}

