/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.exec;

import java.util.concurrent.TimeUnit;
import org.eclipse.scada.utils.exec.OperationResultHandler;

public class OperationResult<R> {
    private OperationResultHandler<R> handler = null;
    private R result = null;
    private Exception exception = null;
    private boolean complete = false;

    public OperationResult() {
        this(null);
    }

    public OperationResult(OperationResultHandler<R> handler) {
        this.handler = handler;
    }

    public synchronized boolean isComplete() {
        return this.complete;
    }

    public synchronized boolean isSuccess() {
        return this.exception == null;
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    public synchronized R getResult() {
        return this.result;
    }

    public synchronized R get() {
        return this.getResult();
    }

    public synchronized void notifySuccess(R result) {
        if (this.complete) {
            return;
        }
        this.complete = true;
        this.result = result;
        this.exception = null;
        this.notifyAll();
        if (this.handler != null) {
            this.handler.success(result);
        }
    }

    public synchronized void notifyFailure(Exception e) {
        if (this.complete) {
            return;
        }
        this.complete = true;
        this.result = null;
        this.exception = e;
        this.notifyAll();
        if (this.handler != null) {
            this.handler.failure(e);
        }
    }

    public synchronized void complete() throws InterruptedException {
        if (this.complete) {
            return;
        }
        this.wait();
    }

    public synchronized boolean complete(long timeout, TimeUnit t) throws InterruptedException {
        if (this.complete) {
            return true;
        }
        this.wait(t.toMillis(timeout));
        return this.complete;
    }
}

